/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.GroupParams;
import asia.redact.bracket.properties.LocaleStringBuilder;
import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.ParseXML;
import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesParser2;
import asia.redact.bracket.properties.PropertiesToken;
import asia.redact.bracket.properties.SortedPropertiesImpl;
import asia.redact.bracket.properties.ValueModel;
import asia.redact.bracket.properties.alt.DotPropertiesParser;
import asia.redact.bracket.properties.line.LineScanner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Properties {
    public Map<String, ValueModel> getPropertyMap();

    public String get(String var1);

    public int intValue(String var1);

    public long longValue(String var1);

    public Date dateValue(String var1);

    public Date dateValue(String var1, String var2) throws ParseException;

    public Node getTree();

    public Node getTree(GroupParams var1);

    public List<String> getComments(String var1);

    public char getSeparator(String var1);

    public void put(String var1, String ... var2);

    public int size();

    public void clear();

    public boolean containsKey(String var1);

    public boolean hasValue(String var1);

    public Properties merge(Properties var1);

    public Properties merge(Properties var1, boolean var2);

    public void synchronize(Node var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory {
        public static Mode mode = Mode.BasicToken;

        public static Properties getInstance() {
            return new PropertiesImpl();
        }

        public static synchronized Properties getInstance(URL url) {
            try {
                return Factory.getInstance(url.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException("IOException caught", e);
            }
        }

        public static synchronized Properties getInstance(Reader reader) {
            switch (mode) {
                case BasicToken: {
                    return new PropertiesImpl(reader);
                }
                case Compatibility: {
                    PropertiesLexer lexer = new PropertiesLexer(reader);
                    lexer.lex();
                    List<PropertiesToken> list = lexer.getList();
                    PropertiesImpl props = new PropertiesImpl();
                    PropertiesParser p = new PropertiesParser(list, props);
                    p.setTrimValues(true);
                    p.parse();
                    return props;
                }
                case Line: {
                    LineScanner lexer = new LineScanner(reader);
                    PropertiesImpl props = new PropertiesImpl();
                    new PropertiesParser2(lexer, props).parse();
                    return props;
                }
            }
            return new PropertiesImpl(reader);
        }

        public static synchronized Properties getInstance(InputStream in) {
            switch (mode) {
                case BasicToken: {
                    return new PropertiesImpl(in);
                }
                case Compatibility: {
                    PropertiesLexer lexer = new PropertiesLexer(in);
                    lexer.lex();
                    List<PropertiesToken> list = lexer.getList();
                    PropertiesImpl props = new PropertiesImpl();
                    PropertiesParser p = new PropertiesParser(list, props);
                    p.setTrimValues(true);
                    p.parse();
                    return props;
                }
                case Line: {
                    LineScanner lexer = new LineScanner(new InputStreamReader(in));
                    PropertiesImpl props = new PropertiesImpl();
                    new PropertiesParser2(lexer, props).parse();
                    return props;
                }
            }
            return new PropertiesImpl(in);
        }

        public static Properties getInstance(java.util.Properties legacy) {
            return new PropertiesImpl(legacy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Properties getInstance(String baseName, Locale locale) {
            LocaleStringBuilder builder = new LocaleStringBuilder(baseName, locale);
            List<String> list = builder.getSearchStrings();
            PropertiesImpl base = new PropertiesImpl();
            for (String s : list) {
                InputStream in = null;
                try {
                    in = Thread.currentThread().getClass().getResourceAsStream(s);
                    if (in == null) continue;
                    base.merge(Factory.getInstance(in));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return base;
        }

        public static synchronized Properties getInstanceFromXML(File file) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                InputStreamReader reader = new InputStreamReader(in);
                BufferedReader breader = new BufferedReader(reader);
                ParseXML parser = new ParseXML();
                parser.parse(breader);
                return parser.getProps();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static synchronized Properties sortedInstance(Properties props) {
            SortedPropertiesImpl impl = new SortedPropertiesImpl();
            return impl.merge(props);
        }

        public static synchronized Properties sortedInstance(Properties props, Comparator<String> comp) {
            SortedPropertiesImpl impl = new SortedPropertiesImpl(comp);
            return impl.merge(props);
        }

        public static synchronized Properties getDotInstance(Reader reader) {
            LineScanner lexer = new LineScanner(reader);
            DotPropertiesParser p = new DotPropertiesParser(lexer);
            p.parse();
            return p.getProperties();
        }

        public static synchronized Properties getDotInstance(InputStream in) {
            LineScanner lexer = new LineScanner(new InputStreamReader(in));
            DotPropertiesParser p = new DotPropertiesParser(lexer);
            p.parse();
            return p.getProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BasicToken,
        Compatibility,
        Line;

    }
}

