/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Node;
import asia.redact.bracket.properties.ValueModel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
implements Node {
    final String name;
    final List<Node> children;
    ValueModel value;

    NodeImpl(String name) {
        this.name = name;
        this.children = new ArrayList<Node>();
    }

    NodeImpl(String name, String value) {
        this(name);
        this.value = new ValueModel(value);
    }

    NodeImpl(String name, ValueModel model) {
        this(name);
        this.value = model;
    }

    @Override
    public void addChild(Node child) {
        this.children.add(child);
    }

    @Override
    public void addChild(String name, String value) {
        NodeImpl n = new NodeImpl(name, value);
        this.addChild(n);
    }

    @Override
    public void addChild(String name, ValueModel model) {
        NodeImpl n = new NodeImpl(name, model);
        this.addChild(n);
    }

    @Override
    public Node getChild(String nodeName) {
        for (Node n : this.children) {
            if (!n.getName().equals(nodeName)) continue;
            return n;
        }
        return null;
    }

    @Override
    public Node getDescendant(String nodePath) {
        Node node = this;
        String[] names = nodePath.split("\\.");
        if (names.length == 0) {
            return null;
        }
        for (String nodeName : names) {
            if ((node = node.getChild(nodeName)) != null) continue;
            return null;
        }
        return node;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public String get() {
        if (this.value == null) {
            throw new RuntimeException("Missing value, which should not happen because you would have called hasValue() to check first.");
        }
        return this.value.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : ((Object)this.children).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeImpl other = (NodeImpl)obj;
        if (this.children == null ? other.children != null : !((Object)this.children).equals(other.children)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    @Override
    public ValueModel getValue() {
        return this.value;
    }
}

