/*
 * Decompiled with CFR 0.152.
 */
package asia.redact.bracket.properties;

import asia.redact.bracket.properties.Properties;
import asia.redact.bracket.properties.ValueModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class BracketPropertiesSAXHandler
extends DefaultHandler {
    Properties props = Properties.Factory.getInstance();
    int count;
    StringBuffer keyBuf;
    Stack<String> keyStack = new Stack();
    List<String> comments = new ArrayList<String>();
    String separator;
    List<String> values = new ArrayList<String>();
    boolean commentOn;
    boolean separatorOn;
    boolean valueOn;

    public Properties getResult() {
        return this.props;
    }

    public void characters(char[] buffer, int start, int length) {
        String temp = new String(buffer, start, length);
        if (this.commentOn) {
            this.comments.add(temp);
        } else if (this.separatorOn) {
            this.separator = temp;
        } else if (this.valueOn) {
            this.values.add(temp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.count == 0) {
            if (!qName.equals("properties")) throw new RuntimeException("Bracket properties serialized with xml must have a top level element called 'properties'");
            String namespace = attributes.getValue("xmlns");
            if (namespace == null || !namespace.equals("http://code.google.com/p/bracket-properties")) {
                throw new RuntimeException("Bad namespace, attribute xmlns must be set to 'http://code.google.com/p/bracket-properties'");
            }
        } else {
            if (qName.equals("comment")) {
                this.commentOn = true;
                return;
            }
            if (qName.equals("separator")) {
                this.separatorOn = true;
                return;
            }
            if (qName.equals("value")) {
                this.valueOn = true;
                return;
            }
            this.keyStack.push(qName);
        }
        ++this.count;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("comment")) {
            this.commentOn = false;
            return;
        }
        if (qName.equals("separator")) {
            this.separatorOn = false;
            return;
        }
        if (qName.equals("value")) {
            this.valueOn = false;
            this.keyBuf = new StringBuffer();
            for (String part : this.keyStack) {
                if (this.keyBuf.length() > 0) {
                    this.keyBuf.append(".");
                }
                this.keyBuf.append(part);
            }
            ValueModel model = new ValueModel();
            model.setSeparator(this.separator.charAt(0));
            for (String value : this.values) {
                model.addValue(value);
            }
            for (String comment : this.comments) {
                model.addComment(comment);
            }
            this.props.getPropertyMap().put(this.keyBuf.toString(), model);
            this.keyBuf = null;
            this.values.clear();
            this.comments.clear();
            this.separator = null;
            this.keyStack.remove(qName);
            return;
        }
        this.keyStack.remove(qName);
    }
}

