package asia.redact.bracket.properties.mgmt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;

import asia.redact.bracket.properties.PropertiesImpl;
import asia.redact.bracket.properties.PropertiesLexer;
import asia.redact.bracket.properties.PropertiesParser;
import asia.redact.bracket.properties.PropertiesToken;

/**
 * Experimental - no junits done yet
 * 
 * @author Dave
 *
 */
public class ServerLocalizedProperties extends PropertiesImpl {

	ServerLocale locale;
	String baseName;
	List<File> locationsToSearch;
	
	public ServerLocalizedProperties(ServerLocale locale, String baseName) {
		super();
		this.locale = locale;
		if(locale == null) throw new RuntimeException("A locale must be provided");
		if(baseName == null || baseName.length()==0) throw new RuntimeException("A baseName must be non-null and non-empty");
	}

	public void loadFrom(List<File> locationsToSearch) {
		ServerLocalizedFileFinder finder = new ServerLocalizedFileFinder(locationsToSearch, baseName);
		List<File> files = finder.findFiles();
		for(File file: files){
			ServerLocalizedFileInfo info = ServerLocale.fromFileName(file.getName());
			if(locale.includes(info.locale)){
				FileReader in;
				try {
					in = new FileReader(file);
					PropertiesLexer lexer = new PropertiesLexer(in);
					lexer.lex();
					List<PropertiesToken> list = lexer.getList();
					new PropertiesParser(list, this).parse();
				} catch (FileNotFoundException e) {
					// fail cleanly and quickly as correct properties 
					// are usually necessary to having non-deterministic behavior later
					throw new RuntimeException(e);
				}
			}
		}
	}
	


}
