/*
 *  This file is part of Bracket Properties
 *  Copyright 2011 David R. Smith
 *
 */
package asia.redact.bracket.properties.mgmt;

import java.net.UnknownHostException;

/**
 * Abstract class which may be useful as a base for builders to get your Server Locale. Trivial.
 * 
 * @author Dave
 *
 */
public abstract class ServerLocaleBuilder {

	public abstract ServerLocale findServerLocale();
	
	/**
	 * Helper method - get the hostname from the local machine by looking at the InetAddress.getLocalHost() 
	 * 
	 * @return the hostname
	 * @throws RuntimeException if fails
	 */
	public String fromInet() {
		java.net.InetAddress localMachine = null;
		try {
			localMachine = java.net.InetAddress.getLocalHost();
		} catch (UnknownHostException e) {
			throw new RuntimeException("This method does not work in your environment, try something else");
		}
		return localMachine.getHostName();
	}
	
	/**
	 * Helper method, set the host name as a System property called "hostname" to use this
	 * 
	 * @return
	 */
	public String fromSystemProperty(){
		String prop = System.getProperty("hostname");
		if(prop == null) {
			throw new RuntimeException("This method requires you to set the hostname as a SystemProperty called 'hostname'");
		}else{
			return prop;
		}
	}
}
