/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import com.sun.mirror.declaration.ClassDeclaration;
import java.io.PrintWriter;
import java.io.Writer;
import org.kohsuke.args4j.apt.AnnotationVisitor;

class XmlWriter
implements AnnotationVisitor {
    private final PrintWriter out;

    public XmlWriter(Writer out, ClassDeclaration d) {
        this.out = new PrintWriter(out);
        this.out.println("<usage class='" + d.getQualifiedName() + "'>");
    }

    public void onOption(String name, String usage) {
        this.out.println("  <option>");
        this.writeTag("name", name);
        this.writeTag("usage", usage);
        this.out.println("  </option>");
    }

    private void writeTag(String tag, String value) {
        this.out.println("    <" + tag + "><![CDATA[" + value + "]]></" + tag + ">");
    }

    public void done() {
        this.out.println("</usage>");
        this.out.close();
    }
}

