/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.apt.AnnotationVisitor;
import org.kohsuke.args4j.apt.AnnotationVisitorReorderer;
import org.kohsuke.args4j.apt.HtmlWriter;
import org.kohsuke.args4j.apt.OptionWithUsage;
import org.kohsuke.args4j.apt.TxtWriter;
import org.kohsuke.args4j.apt.XmlWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorFactoryImpl
implements AnnotationProcessorFactory {
    private File outDir = new File(System.getProperty("args4j.outdir"));
    private String format = System.getProperty("args4j.format");
    private Properties resource = null;

    public AnnotationProcessorFactoryImpl() {
        String res = System.getProperty("args4j.resource");
        if (res != null && res.length() > 0) {
            try {
                this.resource = new Properties();
                this.resource.load(new FileInputStream(res));
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }

    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }

    public Collection<String> supportedAnnotationTypes() {
        return Arrays.asList(Option.class.getName(), Argument.class.getName());
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> annotationTypeDeclarations, final AnnotationProcessorEnvironment env) {
        return new AnnotationProcessor(){

            public void process() {
                Collection params = env.getDeclarationsAnnotatedWith((AnnotationTypeDeclaration)env.getTypeDeclaration(Option.class.getName()));
                final HashSet optionBeans = new HashSet();
                for (Declaration d : params) {
                    d.accept((DeclarationVisitor)new SimpleDeclarationVisitor(){

                        public void visitFieldDeclaration(FieldDeclaration f) {
                            TypeDeclaration dt = f.getDeclaringType();
                            optionBeans.add(dt);
                        }

                        public void visitMethodDeclaration(MethodDeclaration m) {
                            optionBeans.add(m.getDeclaringType());
                        }
                    });
                }
                for (TypeDeclaration t : optionBeans) {
                    if (t instanceof ClassDeclaration) {
                        ClassDeclaration cd = (ClassDeclaration)t;
                        try {
                            AnnotationVisitor writer = AnnotationProcessorFactoryImpl.this.createAnnotationVisitor(cd);
                            env.getMessager().printNotice("Processing " + cd.getQualifiedName());
                            AnnotationProcessorFactoryImpl.this.scan(cd, writer);
                        }
                        catch (IOException e) {
                            env.getMessager().printError(e.getMessage());
                        }
                        continue;
                    }
                    env.getMessager().printError(t.getPosition(), "args4j annotations need to be placed on a class");
                }
            }
        };
    }

    private AnnotationVisitor createAnnotationVisitor(ClassDeclaration cd) throws IOException {
        FileWriter out = new FileWriter(new File(this.outDir, cd.getQualifiedName() + "." + this.format.toLowerCase()));
        AnnotationVisitor writer = this.format.equals("XML") ? new XmlWriter(out, cd) : (this.format.equals("TXT") ? new TxtWriter(out, cd) : new HtmlWriter(out));
        return new AnnotationVisitorReorderer(writer);
    }

    private void scan(ClassDeclaration decl, AnnotationVisitor visitor) {
        while (decl != null) {
            for (FieldDeclaration f : decl.getFields()) {
                this.scan((MemberDeclaration)f, visitor);
            }
            for (MethodDeclaration m : decl.getMethods()) {
                this.scan((MemberDeclaration)m, visitor);
            }
            ClassType sc = decl.getSuperclass();
            if (sc == null) break;
            decl = sc.getDeclaration();
        }
        visitor.done();
    }

    private void scan(MemberDeclaration f, AnnotationVisitor visitor) {
        Option o = (Option)f.getAnnotation(Option.class);
        if (o == null) {
            return;
        }
        String usage = this.getUsage(o);
        if (this.isOptionHidden(usage)) {
            return;
        }
        visitor.onOption(new OptionWithUsage(o, usage));
    }

    private boolean isOptionHidden(String usage) {
        return usage == null || usage.length() == 0;
    }

    private String getUsage(Option o) {
        if (this.resource == null) {
            return o.usage();
        }
        return this.resource.getProperty(o.usage());
    }
}

