/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadingClassLoader
extends ClassLoader {
    protected ReloadingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/') + ".class";
        InputStream is = this.getParent().getResourceAsStream(pathName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            return this.defineClass(name, buf, 0, buf.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }
}

