/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.apt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.args4j.apt.AnnotationVisitor;
import org.kohsuke.args4j.apt.OptionWithUsage;

public class AnnotationVisitorReorderer
implements AnnotationVisitor {
    private AnnotationVisitor target;
    private List<OptionWithUsage> arguments = new ArrayList<OptionWithUsage>();

    public AnnotationVisitorReorderer(AnnotationVisitor target) {
        this.target = target;
    }

    public void onOption(String name, String usage) {
        throw new UnsupportedOperationException("method not used");
    }

    public void onOption(OptionWithUsage optionWithUsage) {
        this.arguments.add(optionWithUsage);
    }

    public void done() {
        this.reorderArguments();
        for (OptionWithUsage argument : this.arguments) {
            this.target.onOption(argument);
        }
        this.target.done();
    }

    private void reorderArguments() {
        Collections.sort(this.arguments, new NaturalOrderOptionsComparator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalOrderOptionsComparator
    implements Comparator<OptionWithUsage> {
        private NaturalOrderOptionsComparator() {
        }

        @Override
        public int compare(OptionWithUsage o1, OptionWithUsage o2) {
            return o1.option.name().compareTo(o2.option.name());
        }
    }
}

