/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain;

import ar.com.fdvs.dj.domain.BooleanExpression;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.util.customexpression.PageNumberCustomExpression;
import ar.com.fdvs.dj.util.customexpression.RecordsInPageCustomExpression;
import ar.com.fdvs.dj.util.customexpression.RecordsInReportCustomExpression;
import java.util.Map;

public class ExpressionHelper {
    private static final BooleanExpression printInFirstPage = new PrintInFirstPage();
    private static final BooleanExpression printNotInFirstPage = new PrintNotInFirstPage();
    private static final CustomExpression pageNumber = new PageNumberCustomExpression();
    private static final CustomExpression recordsInPage = new RecordsInPageCustomExpression();
    private static final CustomExpression recordsInReport = new RecordsInReportCustomExpression();

    public static BooleanExpression printInFirstPage() {
        return printInFirstPage;
    }

    public static BooleanExpression printNotInFirstPage() {
        return printNotInFirstPage;
    }

    public static CustomExpression getPageNumber() {
        return pageNumber;
    }

    public static CustomExpression getRecordsInPage() {
        return recordsInPage;
    }

    public static CustomExpression getRecordsInReport() {
        return recordsInReport;
    }

    public static BooleanExpression printWhenGroupHasMoreThanOneRecord(final String groupName) {
        return new BooleanExpression(){
            private static final long serialVersionUID = 10000L;

            @Override
            public Object evaluate(Map fields, Map variables, Map parameters) {
                return ExpressionHelper.getGroupCount(groupName, variables) > 1;
            }
        };
    }

    public static int getPageNumber(Map variables) {
        return (Integer)variables.get("PAGE_NUMBER");
    }

    public static int getGroupCount(String groupName, Map variables) {
        return (Integer)variables.get(groupName + "_COUNT");
    }

    private static class PrintInFirstPage
    extends BooleanExpression {
        private static final long serialVersionUID = 10000L;

        private PrintInFirstPage() {
        }

        @Override
        public Object evaluate(Map fields, Map variables, Map parameters) {
            return ExpressionHelper.getPageNumber(variables) == 1;
        }
    }

    private static class PrintNotInFirstPage
    extends BooleanExpression {
        private static final long serialVersionUID = 10000L;

        private PrintNotInFirstPage() {
        }

        @Override
        public Object evaluate(Map fields, Map variables, Map parameters) {
            return ExpressionHelper.getPageNumber(variables) > 1;
        }
    }
}

