/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.output.ReportWriter;
import ar.com.fdvs.dj.output.ReportWriterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;

public class DJServletHelper {
    private static ThreadLocal<Integer> pageTreshold = new ThreadLocal();

    public static void setPageTreshold(int treshold) {
        if (treshold >= 0) {
            pageTreshold.set(treshold);
        }
    }

    public static void exportToHtml(HttpServletRequest request, HttpServletResponse response, String imageServletUrl, DynamicReport dynamicReport, LayoutManager layoutManager, JRDataSource ds, Map parameters, Map exporterParams) throws JRException, IOException {
        if (parameters == null) {
            parameters = new HashMap();
        }
        if (exporterParams == null) {
            exporterParams = new HashMap();
        }
        JasperPrint _jasperPrint = DynamicJasperHelper.generateJasperPrint(dynamicReport, layoutManager, ds, parameters);
        DJServletHelper.exportToHtml(request, response, imageServletUrl, _jasperPrint, exporterParams);
    }

    public static void exportToHtml(HttpServletRequest request, HttpServletResponse response, String imageServletUrl, JasperPrint jasperPrint, Map exporterParams) throws JRException, IOException {
        if (exporterParams == null) {
            exporterParams = new HashMap<JRHtmlExporterParameter, String>();
        }
        exporterParams.put(JRHtmlExporterParameter.IMAGES_URI, request.getContextPath() + imageServletUrl);
        ReportWriter reportWriter = ReportWriterFactory.build(pageTreshold.get()).getReportWriter(jasperPrint, "HTML", exporterParams);
        HashMap imagesMap = new HashMap();
        JRExporter exporter = reportWriter.getExporter();
        exporter.setParameters(exporterParams);
        DJServletHelper.setupParameters(request, imageServletUrl, jasperPrint, imagesMap, exporter);
        reportWriter.writeTo(response);
    }

    public static InputStream exportToHtml(HttpServletRequest request, String imageServletUrl, DynamicReport dynamicReport, LayoutManager layoutManager, JRDataSource ds, Map parameters, Map exporterParams) throws JRException, IOException {
        if (parameters == null) {
            parameters = new HashMap();
        }
        if (exporterParams == null) {
            exporterParams = new HashMap();
        }
        JasperPrint _jasperPrint = DynamicJasperHelper.generateJasperPrint(dynamicReport, layoutManager, ds, parameters);
        return DJServletHelper.exportToHtml(request, imageServletUrl, _jasperPrint, exporterParams);
    }

    public static InputStream exportToHtml(HttpServletRequest request, String imageServletUrl, JasperPrint jasperPrint, Map exporterParams) throws JRException, IOException {
        if (exporterParams == null) {
            exporterParams = new HashMap<JRHtmlExporterParameter, String>();
        }
        exporterParams.put(JRHtmlExporterParameter.IMAGES_URI, request.getContextPath() + imageServletUrl);
        ReportWriter reportWriter = ReportWriterFactory.build(pageTreshold.get()).getReportWriter(jasperPrint, "HTML", exporterParams);
        HashMap imagesMap = new HashMap();
        JRExporter exporter = reportWriter.getExporter();
        exporter.setParameters(exporterParams);
        DJServletHelper.setupParameters(request, imageServletUrl, jasperPrint, imagesMap, exporter);
        return reportWriter.write();
    }

    private static void setupParameters(HttpServletRequest request, String imageServletUrl, JasperPrint jasperPrint, Map imagesMap, JRExporter exporter) {
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, (Object)imagesMap);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(request.getContextPath() + "/" + imageServletUrl + "?image="));
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        HttpSession session = request.getSession();
        session.setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
        session.setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
    }

    static {
        pageTreshold.set(5);
    }
}

