/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.core.DJConstants;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJQuery;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.ImageBanner;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.builders.SubReportBuilder;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.DJColSpan;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.DJGroupVariableDef;
import ar.com.fdvs.dj.domain.entities.DJVariable;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.GlobalGroupColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;

public class DynamicReportBuilder {
    protected DynamicReport report = new DynamicReport();
    protected DynamicReportOptions options = new DynamicReportOptions();
    protected ArrayList globalFooterCrosstabs;
    protected ArrayList globalHeaderCrosstabs;
    protected ArrayList autoTexts;
    protected Map groupFooterSubreports = new HashMap();
    protected Map groupHeaderSubreports = new HashMap();
    protected DJGroup globalVariablesGroup;
    protected ArrayList concatenatedReports = new ArrayList();

    public DynamicReportBuilder() {
        this.globalVariablesGroup = this.createDummyGroup();
    }

    public DynamicReportBuilder addAutoText(AutoText text) {
        if (this.autoTexts == null) {
            this.autoTexts = new ArrayList();
        }
        if (AutoText.WIDTH_NOT_SET.equals(text.getWidth())) {
            text.setWidth(AutoText.DEFAULT_WIDTH);
        }
        if (AutoText.WIDTH_NOT_SET.equals(text.getWidth2())) {
            text.setWidth2(AutoText.DEFAULT_WIDTH);
        }
        this.autoTexts.add(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_, pattern);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, byte pattern, int width, int width2) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_, pattern, width, width2);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(String message, byte position, byte alignment) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(message, position, alignment_);
        text.setWidth(AutoText.WIDTH_NOT_SET);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(String message, byte position, byte alignment, int width) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(message, position, alignment_, new Integer(width));
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(String message, byte position, byte alignment, int width, Style style) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(message, position, alignment_, new Integer(width));
        text.setStyle(style);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_);
        text.setWidth(new Integer(width));
        text.setWidth2(new Integer(width2));
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment, int width, int width2, Style style) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_);
        text.setWidth(new Integer(width));
        text.setWidth2(new Integer(width2));
        text.setStyle(style);
        this.addAutoText(text);
        return this;
    }

    public DynamicReportBuilder addAutoText(byte type, byte position, byte alignment) {
        HorizontalBandAlignment alignment_ = HorizontalBandAlignment.buildAligment(alignment);
        AutoText text = new AutoText(type, position, alignment_);
        text.setWidth(AutoText.WIDTH_NOT_SET);
        text.setWidth2(AutoText.WIDTH_NOT_SET);
        this.addAutoText(text);
        return this;
    }

    public DynamicReport build() {
        this.report.setOptions(this.options);
        if (!this.globalVariablesGroup.getFooterVariables().isEmpty() || !this.globalVariablesGroup.getHeaderVariables().isEmpty() || !this.globalVariablesGroup.getVariables().isEmpty() || this.hasPercentageColumn()) {
            this.report.getColumnsGroups().add(0, this.globalVariablesGroup);
        }
        this.createChartGroups();
        this.addGlobalCrosstabs();
        this.addSubreportsToGroups();
        this.concatenateReports();
        this.report.setAutoTexts(this.autoTexts);
        return this.report;
    }

    private boolean hasPercentageColumn() {
        Iterator<AbstractColumn> iterator = this.report.getColumns().iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof PercentageColumn)) continue;
            return true;
        }
        return false;
    }

    private void addGlobalCrosstabs() {
        DJGroup globalGroup;
        if (this.globalHeaderCrosstabs != null) {
            for (DJCrosstab djcross : this.globalHeaderCrosstabs) {
                globalGroup = this.createDummyGroupForCrosstabs("crosstabHeaderGroup-" + this.globalHeaderCrosstabs.indexOf(djcross));
                globalGroup.getHeaderCrosstabs().add(djcross);
                this.report.getColumnsGroups().add(0, globalGroup);
            }
        }
        if (this.globalFooterCrosstabs != null) {
            for (DJCrosstab djcross : this.globalFooterCrosstabs) {
                globalGroup = this.createDummyGroupForCrosstabs("crosstabFooterGroup-" + this.globalFooterCrosstabs.indexOf(djcross));
                globalGroup.getFooterCrosstabs().add(djcross);
                this.report.getColumnsGroups().add(0, globalGroup);
            }
        }
    }

    protected void addSubreportsToGroups() {
        DJGroup group;
        List list;
        for (Integer groupNum : this.groupFooterSubreports.keySet()) {
            list = (List)this.groupFooterSubreports.get(groupNum);
            group = (DJGroup)this.report.getColumnsGroups().get(groupNum - 1);
            group.getFooterSubreports().addAll(list);
        }
        for (Integer groupNum : this.groupHeaderSubreports.keySet()) {
            list = (List)this.groupHeaderSubreports.get(groupNum);
            group = (DJGroup)this.report.getColumnsGroups().get(groupNum - 1);
            group.getHeaderSubreports().addAll(list);
        }
    }

    protected void concatenateReports() {
        if (!this.concatenatedReports.isEmpty()) {
            DJGroup globalGroup = this.createDummyGroup();
            this.report.getColumnsGroups().add(0, globalGroup);
        }
        for (Subreport subreport : this.concatenatedReports) {
            DJGroup globalGroup = this.createDummyGroup();
            globalGroup.getFooterSubreports().add(subreport);
            this.report.getColumnsGroups().add(0, globalGroup);
        }
    }

    private DJGroup createDummyGroup() {
        DJGroup globalGroup = new DJGroup();
        globalGroup.setLayout(GroupLayout.EMPTY);
        GlobalGroupColumn globalCol = new GlobalGroupColumn("global");
        globalGroup.setColumnToGroupBy(globalCol);
        return globalGroup;
    }

    private DJGroup createDummyGroupForCrosstabs(String name) {
        DJGroup globalGroup = new DJGroup();
        globalGroup.setLayout(GroupLayout.EMPTY);
        GlobalGroupColumn globalCol = new GlobalGroupColumn(name);
        globalCol.setTitle("");
        globalGroup.setColumnToGroupBy(globalCol);
        return globalGroup;
    }

    public DynamicReportBuilder setTitle(String title) {
        this.report.setTitle(title);
        return this;
    }

    public DynamicReportBuilder setTitleIsJrExpression(boolean isExpression) {
        this.report.setTitleIsJrExpression(isExpression);
        return this;
    }

    public DynamicReportBuilder setReportName(String reportName) {
        this.report.setReportName(reportName);
        return this;
    }

    public DynamicReportBuilder setSubtitle(String subtitle) {
        this.report.setSubtitle(subtitle);
        return this;
    }

    public DynamicReportBuilder addColumn(AbstractColumn column) {
        this.report.getColumns().add(column);
        return this;
    }

    public List getColumns() {
        return Collections.unmodifiableList(this.report.getColumns());
    }

    public DynamicReportBuilder addGroup(DJGroup group) {
        this.report.getColumnsGroups().add(group);
        return this;
    }

    public DynamicReportBuilder setHeaderHeight(Integer height) {
        this.options.setHeaderHeight(height);
        return this;
    }

    public DynamicReportBuilder setHeaderHeight(int height) {
        this.options.setHeaderHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setFooterHeight(Integer height) {
        this.options.setFooterVariablesHeight(height);
        return this;
    }

    public DynamicReportBuilder setFooterHeight(int height) {
        this.options.setFooterVariablesHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setFooterVariablesHeight(Integer height) {
        this.options.setFooterVariablesHeight(height);
        return this;
    }

    public DynamicReportBuilder setFooterVariablesHeight(int height) {
        this.options.setFooterVariablesHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setHeaderVariablesHeight(Integer height) {
        this.options.setHeaderVariablesHeight(height);
        return this;
    }

    public DynamicReportBuilder setDetailHeight(Integer height) {
        this.options.setDetailHeight(height);
        return this;
    }

    public DynamicReportBuilder setDetailHeight(int height) {
        this.options.setDetailHeight(new Integer(height));
        return this;
    }

    public DynamicReportBuilder setLeftMargin(Integer margin) {
        this.options.setLeftMargin(margin);
        return this;
    }

    public DynamicReportBuilder setLeftMargin(int margin) {
        this.options.setLeftMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setRightMargin(Integer margin) {
        this.options.setRightMargin(margin);
        return this;
    }

    public DynamicReportBuilder setRightMargin(int margin) {
        this.options.setRightMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setTopMargin(Integer margin) {
        this.options.setTopMargin(margin);
        return this;
    }

    public DynamicReportBuilder setTopMargin(int margin) {
        this.options.setTopMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setBottomMargin(Integer margin) {
        this.options.setBottomMargin(margin);
        return this;
    }

    public DynamicReportBuilder setBottomMargin(int margin) {
        this.options.setBottomMargin(new Integer(margin));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(Integer numColumns) {
        this.options.setColumnsPerPage(numColumns);
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(int numColumns) {
        this.options.setColumnsPerPage(new Integer(numColumns));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(int numColumns, int columnSpace) {
        this.options.setColumnsPerPage(new Integer(numColumns));
        this.options.setColumnSpace(new Integer(columnSpace));
        return this;
    }

    public DynamicReportBuilder setColumnsPerPage(Integer numColumns, Integer columnSpace) {
        this.options.setColumnsPerPage(numColumns);
        this.options.setColumnSpace(columnSpace);
        return this;
    }

    public DynamicReportBuilder setColumnSpace(Integer columSpace) {
        this.options.setColumnSpace(columSpace);
        return this;
    }

    public DynamicReportBuilder setColumnSpace(int columSpace) {
        this.options.setColumnSpace(new Integer(columSpace));
        return this;
    }

    public DynamicReportBuilder setPrintColumnNames(boolean bool) {
        this.options.setPrintColumnNames(bool);
        return this;
    }

    public DynamicReportBuilder setIgnorePagination(boolean bool) {
        this.options.setIgnorePagination(bool);
        return this;
    }

    public DynamicReportBuilder setUseFullPageWidth(boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder setUseFullPageWidth(Boolean useFullwidth) {
        this.options.setUseFullPageWidth(useFullwidth);
        return this;
    }

    public DynamicReportBuilder setTitleStyle(Style titleStyle) {
        this.report.setTitleStyle(titleStyle);
        return this;
    }

    public DynamicReportBuilder setSubtitleStyle(Style subtitleStyle) {
        this.report.setSubtitleStyle(subtitleStyle);
        return this;
    }

    public DynamicReportBuilder setPrintBackgroundOnOddRows(boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder setPrintBackgroundOnOddRows(Boolean printBackgroundOnOddRows) {
        this.options.setPrintBackgroundOnOddRows(printBackgroundOnOddRows);
        return this;
    }

    public DynamicReportBuilder setOddRowBackgroundStyle(Style oddRowBackgroundStyle) {
        this.options.setOddRowBackgroundStyle(oddRowBackgroundStyle);
        return this;
    }

    public DynamicReportBuilder setGrandTotalLegend(String title) {
        this.globalVariablesGroup.getColumnToGroupBy().setTitle(title);
        return this;
    }

    public DynamicReportBuilder setGlobalHeaderVariableHeight(Integer height) {
        this.globalVariablesGroup.setHeaderVariablesHeight(height);
        return this;
    }

    public DynamicReportBuilder setGlobalFooterVariableHeight(Integer height) {
        this.globalVariablesGroup.setFooterVariablesHeight(height);
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op) {
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op));
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op, Style style) {
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op, style));
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op, style, valueFormatter));
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(DJGroupVariable variable) {
        this.globalVariablesGroup.addHeaderVariable(variable);
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(column, valueExpression));
        return this;
    }

    public DynamicReportBuilder addGlobalHeaderVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(column, valueExpression, style));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op) {
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op, Style style) {
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op, style));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op, style, valueFormatter));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(DJGroupVariable variable) {
        this.globalVariablesGroup.addFooterVariable(variable);
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn column, CustomExpression valueExpression) {
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(column, valueExpression));
        return this;
    }

    public DynamicReportBuilder addGlobalFooterVariable(AbstractColumn column, CustomExpression valueExpression, Style style) {
        this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(column, valueExpression, style));
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op));
        } else {
            this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op));
        }
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op, Style style) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op, style));
        } else {
            this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op, style));
        }
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, AbstractColumn col, DJCalculation op, Style style, DJValueFormatter valueFormatter) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(col, op, style, valueFormatter));
        } else {
            this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(col, op, style, valueFormatter));
        }
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, DJGroupVariable variable) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(variable);
        } else {
            this.globalVariablesGroup.addHeaderVariable(variable);
        }
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, AbstractColumn column, CustomExpression valueExpression) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(column, valueExpression));
        } else {
            this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(column, valueExpression));
        }
        return this;
    }

    public DynamicReportBuilder addGlobalColumnVariable(String position, AbstractColumn column, CustomExpression valueExpression, Style style) {
        if ("footer".equals(position)) {
            this.globalVariablesGroup.addFooterVariable(new DJGroupVariable(column, valueExpression, style));
        } else {
            this.globalVariablesGroup.addHeaderVariable(new DJGroupVariable(column, valueExpression, style));
        }
        return this;
    }

    public DynamicReportBuilder addGlobalVariable(String name, AbstractColumn col, DJCalculation op) {
        this.globalVariablesGroup.addVariable(new DJGroupVariableDef(name, col, op));
        return this;
    }

    public DynamicReportBuilder addGlobalVariable(String name, ColumnProperty prop, DJCalculation op) {
        this.globalVariablesGroup.addVariable(new DJGroupVariableDef(name, prop, op));
        return this;
    }

    public DynamicReportBuilder addGlobalVariable(String name, String property, String className, DJCalculation op) {
        this.globalVariablesGroup.addVariable(new DJGroupVariableDef(name, new ColumnProperty(property, className), op));
        return this;
    }

    public DynamicReportBuilder setTitleHeight(Integer height) {
        this.options.setTitleHeight(height);
        return this;
    }

    public DynamicReportBuilder setSubtitleHeight(Integer height) {
        this.options.setSubtitleHeight(height);
        return this;
    }

    public DynamicReportBuilder setPageSizeAndOrientation(Page page) {
        this.options.setPage(page);
        return this;
    }

    public DynamicReportBuilder addImageBanner(String path, Integer width, Integer height, byte align) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        this.options.getImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addImageBanner(String path, Integer width, Integer height, byte align, ImageScaleMode scaleMode) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        banner.setScaleMode(scaleMode);
        this.options.getImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addFirstPageImageBanner(String path, Integer width, Integer height, byte align) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        this.options.getFirstPageImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addFirstPageImageBanner(String path, Integer width, Integer height, byte align, ImageScaleMode scaleMode) {
        ImageBanner banner = new ImageBanner(path, width, height, align);
        banner.setScaleMode(scaleMode);
        this.options.getFirstPageImageBanners().put(new Byte(align), banner);
        return this;
    }

    public DynamicReportBuilder addField(String name, String className) {
        return this.addField(new ColumnProperty(name, className));
    }

    public DynamicReportBuilder addField(String name, Class clazz) {
        return this.addField(new ColumnProperty(name, clazz.getName()));
    }

    public DynamicReportBuilder addField(ColumnProperty columnProperty) {
        this.report.getFields().add(columnProperty);
        return this;
    }

    public List getFields() {
        return this.report.getFields();
    }

    public DynamicReportBuilder addChart(DJChart chart) {
        this.report.getCharts().add(chart);
        return this;
    }

    public DynamicReportBuilder addChart(ar.com.fdvs.dj.domain.chart.DJChart djChart) {
        this.report.getNewCharts().add(djChart);
        return this;
    }

    private void createChartGroups() {
        for (ar.com.fdvs.dj.domain.chart.DJChart djChart : this.report.getNewCharts()) {
            DJGroup djGroup = this.getChartColumnsGroup(djChart);
            if (djGroup != null) continue;
            djGroup = new GroupBuilder().setCriteriaColumn(djChart.getDataset().getColumnsGroup()).setGroupLayout(GroupLayout.VALUE_FOR_EACH).build();
            this.addGroup(djGroup);
        }
    }

    private DJGroup getChartColumnsGroup(ar.com.fdvs.dj.domain.chart.DJChart djChart) {
        PropertyColumn columnsGroup = djChart.getDataset().getColumnsGroup();
        for (DJGroup djGroup : this.report.getColumnsGroups()) {
            if (djGroup.getColumnToGroupBy() != columnsGroup) continue;
            return djGroup;
        }
        return null;
    }

    public DynamicReportBuilder setTemplateFile(String path) {
        this.report.setTemplateFileName(path);
        return this;
    }

    public DynamicReportBuilder setTemplateFile(String path, boolean importFields, boolean importVariables, boolean importParameters, boolean importDatasets) {
        this.report.setTemplateFileName(path);
        this.report.setTemplateImportFields(importFields);
        this.report.setTemplateImportParameters(importParameters);
        this.report.setTemplateImportVariables(importVariables);
        this.report.setTemplateImportDatasets(importDatasets);
        return this;
    }

    public DynamicReportBuilder setMargins(int top, int bottom, int left, int right) {
        this.options.setTopMargin(new Integer(top));
        this.options.setBottomMargin(new Integer(bottom));
        this.options.setLeftMargin(new Integer(left));
        this.options.setRightMargin(new Integer(right));
        return this;
    }

    public DynamicReportBuilder setDefaultStyles(Style title, Style subtitle, Style columnHeader, Style columDetail) {
        if (columDetail != null) {
            this.options.setDefaultDetailStyle(columDetail);
        }
        if (columnHeader != null) {
            this.options.setDefaultHeaderStyle(columnHeader);
        }
        if (subtitle != null) {
            this.report.setSubtitleStyle(subtitle);
        }
        if (title != null) {
            this.report.setTitleStyle(title);
        }
        return this;
    }

    public DynamicReportBuilder setReportLocale(Locale locale) {
        this.report.setReportLocale(locale);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(Subreport subreport) {
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startOnNewPage) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).setStartInNewPage(startOnNewPage).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(JasperReport jasperReport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setReport(jasperReport).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addConcatenatedReport(JasperReport jasperReport, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startOnNewPage) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setReport(jasperReport).setStartInNewPage(startOnNewPage).build();
        this.concatenatedReports.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, Subreport subreport) {
        Integer groupNum = new Integer(groupNumber);
        ArrayList<Subreport> list = (ArrayList<Subreport>)this.groupFooterSubreports.get(groupNum);
        if (list == null) {
            list = new ArrayList<Subreport>();
            this.groupFooterSubreports.put(groupNum, list);
        }
        list.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroup(String position, int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        if ("footer".equals(position)) {
            this.addSubreportInGroupFooter(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params);
        } else {
            this.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params);
        }
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager).setFitToParentPrintableArea(fitParent);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroup(String position, int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        if ("footer".equals(position)) {
            this.addSubreportInGroupFooter(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage, fitParent);
        } else {
            this.addSubreportInGroupHeader(groupNumber, dynamicReport, layoutManager, dataSourcePath, dataSourceOrigin, dataSourceType, params, startInNewPage, fitParent);
        }
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType, SubreportParameter[] params, boolean startInNewPage, boolean fitParent) throws DJBuilderException {
        SubReportBuilder srb = new SubReportBuilder();
        srb.setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setStartInNewPage(startInNewPage).setDynamicReport(dynamicReport, layoutManager).setFitToParentPrintableArea(fitParent);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                srb.addParameter(params[i]);
            }
        }
        Subreport subreport = srb.build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupFooter(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType, boolean startInNewPage) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).setStartInNewPage(startInNewPage).build();
        return this.addSubreportInGroupFooter(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, Subreport subreport) {
        Integer groupNum = new Integer(groupNumber);
        ArrayList<Subreport> list = (ArrayList<Subreport>)this.groupHeaderSubreports.get(groupNum);
        if (list == null) {
            list = new ArrayList<Subreport>();
            this.groupHeaderSubreports.put(groupNum, list);
        }
        list.add(subreport);
        return this;
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, DynamicReport dynamicReport, LayoutManager layoutManager, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setDynamicReport(dynamicReport, layoutManager).build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addSubreportInGroupHeader(int groupNumber, String pathToSubreport, String dataSourcePath, int dataSourceOrigin, int dataSourceType) throws DJBuilderException {
        Subreport subreport = new SubReportBuilder().setDataSource(dataSourceOrigin, dataSourceType, dataSourcePath).setPathToReport(pathToSubreport).build();
        return this.addSubreportInGroupHeader(groupNumber, subreport);
    }

    public DynamicReportBuilder addStyle(Style style) throws DJBuilderException {
        if (style.getName() == null) {
            throw new DJBuilderException("Invalid style. The style must have a name");
        }
        this.report.addStyle(style);
        return this;
    }

    public DynamicReportBuilder addResourceBundle(String resourceBundle) {
        return this.setResourceBundle(resourceBundle);
    }

    public DynamicReportBuilder setResourceBundle(String resourceBundle) {
        this.report.setResourceBundle(resourceBundle);
        return this;
    }

    public DynamicReportBuilder setGrandTotalLegendStyle(Style grandTotalStyle) {
        this.globalVariablesGroup.getColumnToGroupBy().setHeaderStyle(grandTotalStyle);
        this.globalVariablesGroup.getColumnToGroupBy().setStyle(grandTotalStyle);
        return this;
    }

    public DynamicReportBuilder addHeaderCrosstab(DJCrosstab cross) {
        if (this.globalHeaderCrosstabs == null) {
            this.globalHeaderCrosstabs = new ArrayList();
        }
        this.globalHeaderCrosstabs.add(cross);
        return this;
    }

    public DynamicReportBuilder addFooterCrosstab(DJCrosstab cross) {
        if (this.globalFooterCrosstabs == null) {
            this.globalFooterCrosstabs = new ArrayList();
        }
        this.globalFooterCrosstabs.add(cross);
        return this;
    }

    public DynamicReportBuilder setQuery(String text, String language) {
        this.report.setQuery(new DJQuery(text, language));
        return this;
    }

    public DynamicReportBuilder addFont(String fontName, Font font) {
        this.report.getFontsMap().put(fontName, font);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataType(byte whenNoDataType) {
        this.report.setWhenNoDataType(whenNoDataType);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataNoPages() {
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_NO_PAGES);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataBlankPage() {
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_BLANK_PAGE);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataAllSectionNoDetail() {
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_ALL_SECTIONS_NO_DETAIL);
        return this;
    }

    public DynamicReportBuilder setWhenNoDataShowNoDataSection() {
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_NO_DATA_SECTION);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissing(byte whenResourceMissing) {
        this.report.setWhenResourceMissing(whenResourceMissing);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingLeaveEmptySpace() {
        this.report.setWhenResourceMissing(DJConstants.WHEN_RESOURCE_MISSING_TYPE_EMPTY);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingThrowException() {
        this.report.setWhenResourceMissing(DJConstants.WHEN_RESOURCE_MISSING_TYPE_ERROR);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingShowKey() {
        this.report.setWhenResourceMissing(DJConstants.WHEN_RESOURCE_MISSING_TYPE_KEY);
        return this;
    }

    public DynamicReportBuilder setWhenResourceMissingReturnNull() {
        this.report.setWhenResourceMissing(DJConstants.WHEN_RESOURCE_MISSING_TYPE_NULL);
        return this;
    }

    public DynamicReportBuilder setWhenNoData(String text, Style style) {
        this.report.setWhenNoDataStyle(style);
        this.report.setWhenNoDataText(text);
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_NO_DATA_SECTION);
        return this;
    }

    public DynamicReportBuilder setWhenNoData(String text, Style style, boolean showTitle, boolean showColumnHeader) {
        this.report.setWhenNoDataStyle(style);
        this.report.setWhenNoDataText(text);
        this.report.setWhenNoDataType(DJConstants.WHEN_NO_DATA_TYPE_NO_DATA_SECTION);
        this.report.setWhenNoDataShowColumnHeader(showColumnHeader);
        this.report.setWhenNoDataShowTitle(showTitle);
        return this;
    }

    public DynamicReportBuilder addParameter(String name, String className) {
        this.report.addParameter(name, className);
        return this;
    }

    public DynamicReportBuilder setAllowDetailSplit(boolean split) {
        this.report.setAllowDetailSplit(split);
        return this;
    }

    public DynamicReportBuilder setProperty(String name, String value) {
        this.report.setProperty(name, value);
        return this;
    }

    public DynamicReportBuilder setShowDetailBand(boolean bool) {
        this.options.setShowDetailBand(bool);
        return this;
    }

    public AbstractColumn getColumn(int idx) {
        return this.report.getColumns().get(idx);
    }

    public DJGroup getGroup(int idx) {
        return (DJGroup)this.report.getColumnsGroups().get(idx);
    }

    public DynamicReportBuilder setTitle(String title, boolean isExpression) {
        this.setTitle(title);
        this.setTitleIsJrExpression(isExpression);
        return this;
    }

    public DynamicReportBuilder addVariable(DJVariable var) {
        this.report.getVariables().add(var);
        return this;
    }

    public DynamicReportBuilder setColspan(int colNumber, int colQuantity, String colspanTitle) {
        this.setColspan(colNumber, colQuantity, colspanTitle, null);
        return this;
    }

    public DynamicReportBuilder setColspan(int colNumber, int colQuantity, String colspanTitle, Style colspanStyle) {
        List<AbstractColumn> cols;
        try {
            cols = this.report.getColumns().subList(colNumber, colQuantity + colNumber);
        }
        catch (IndexOutOfBoundsException e) {
            String message = "Cols must be between 0 and " + (this.report.getColumns().size() - 1);
            throw new ColumnBuilderException(message, e);
        }
        DJColSpan colSpan = new DJColSpan();
        colSpan.setTitle(colspanTitle);
        colSpan.setColumns(cols);
        colSpan.setColspanHeaderStyle(colspanStyle);
        for (AbstractColumn abstractColumn : colSpan.getColumns()) {
            abstractColumn.setColSpan(colSpan);
        }
        return this;
    }

    public DynamicReportBuilder setLanguage(String language) {
        this.report.setLanguage(language);
        return this;
    }
}

