/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.domain.DJQuery;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.constants.Page;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJJRDesignHelper {
    private static final Log log = LogFactory.getLog((Class)DJJRDesignHelper.class);

    public static DynamicJasperDesign getNewDesign(DynamicReport dr) {
        log.info((Object)"obtaining DynamicJasperDesign instance");
        DynamicJasperDesign des = new DynamicJasperDesign();
        DynamicReportOptions options = dr.getOptions();
        Page page = options.getPage();
        des.setColumnCount(options.getColumnsPerPage());
        des.setPrintOrder((byte)1);
        byte orientation = page.isOrientationPortrait() ? (byte)1 : 2;
        des.setOrientation(orientation);
        des.setPageWidth(page.getWidth());
        des.setPageHeight(page.getHeight());
        des.setColumnWidth(options.getColumnWidth());
        des.setColumnSpacing(options.getColumnSpace());
        des.setLeftMargin(options.getLeftMargin());
        des.setRightMargin(options.getRightMargin());
        des.setTopMargin(options.getTopMargin());
        des.setBottomMargin(options.getBottomMargin());
        des.setWhenNoDataType(dr.getWhenNoDataType());
        des.setWhenResourceMissingType(dr.getWhenResourceMissing());
        des.setTitleNewPage(false);
        des.setSummaryNewPage(false);
        des.setDetail((JRBand)new JRDesignBand());
        des.getDetail().setSplitAllowed(dr.isAllowDetailSplit());
        des.setPageHeader((JRBand)new JRDesignBand());
        des.setPageFooter((JRBand)new JRDesignBand());
        des.setSummary((JRBand)new JRDesignBand());
        des.setTitleNewPage(options.isTitleNewPage());
        des.setIgnorePagination(options.isIgnorePagination());
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            des.setQuery(query);
        }
        Iterator iterator = dr.getProperties().keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            des.setProperty(name, (String)dr.getProperties().get(name));
        }
        des.setName(dr.getReportName() != null ? dr.getReportName() : "DynamicReport");
        return des;
    }

    protected static JRDesignQuery getJRDesignQuery(DynamicReport dr) {
        JRDesignQuery query = new JRDesignQuery();
        query.setText(dr.getQuery().getText());
        query.setLanguage(dr.getQuery().getLanguage());
        return query;
    }

    public static DynamicJasperDesign downCast(JasperDesign jd, DynamicReport dr) throws CoreException {
        DynamicJasperDesign djd = new DynamicJasperDesign();
        log.info((Object)"downcasting JasperDesign");
        try {
            JRParameter element;
            Iterator iter;
            BeanUtils.copyProperties((Object)((Object)djd), (Object)jd);
            if (dr.isTemplateImportParameters()) {
                iter = jd.getParametersList().iterator();
                while (iter.hasNext()) {
                    element = (JRParameter)iter.next();
                    try {
                        djd.addParameter(element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportFields()) {
                iter = jd.getFieldsList().iterator();
                while (iter.hasNext()) {
                    element = (JRField)iter.next();
                    try {
                        djd.addField((JRField)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportVariables()) {
                iter = jd.getVariablesList().iterator();
                while (iter.hasNext()) {
                    element = (JRVariable)iter.next();
                    try {
                        if (!(element instanceof JRDesignVariable)) continue;
                        djd.addVariable((JRDesignVariable)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportDatasets()) {
                JRQuery query = jd.getQuery();
                if (query instanceof JRDesignQuery) {
                    djd.setQuery((JRDesignQuery)query);
                    dr.setQuery(new DJQuery(query.getText(), query.getLanguage()));
                }
                Iterator iter2 = jd.getDatasetsList().iterator();
                while (iter2.hasNext()) {
                    JRDesignDataset dataset = (JRDesignDataset)iter2.next();
                    try {
                        djd.addDataset(dataset);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            String[] properties = jd.getPropertyNames();
            for (int i = 0; i < properties.length; ++i) {
                String propName = properties[i];
                String propValue = jd.getProperty(propName);
                djd.setProperty(propName, propValue);
            }
            Iterator iterator = jd.getStylesList().iterator();
            while (iterator.hasNext()) {
                JRStyle style = (JRStyle)iterator.next();
                try {
                    djd.addStyle(style);
                }
                catch (JRException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.warn((Object)("Duplicated style (style name \"" + style.getName() + "\") when loading design: " + e.getMessage()), (Throwable)e);
                }
            }
            JRReportTemplate[] templates = jd.getTemplates();
            if (templates != null) {
                for (int i = 0; i < templates.length; ++i) {
                    djd.addTemplate(templates[i]);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return djd;
    }

    protected static void populateReportOptionsFromDesign(DynamicJasperDesign jd, DynamicReport dr) {
        DynamicReportOptions options = dr.getOptions();
        options.setBottomMargin(new Integer(jd.getBottomMargin()));
        options.setTopMargin(new Integer(jd.getTopMargin()));
        options.setLeftMargin(new Integer(jd.getLeftMargin()));
        options.setRightMargin(new Integer(jd.getRightMargin()));
        options.setColumnSpace(new Integer(jd.getColumnSpacing()));
        options.setColumnsPerPage(new Integer(jd.getColumnCount()));
        options.setPage(new Page(jd.getPageHeight(), jd.getPageWidth()));
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            jd.setQuery(query);
        }
        if (dr.getReportName() != null) {
            jd.setName(dr.getReportName());
        }
    }
}

