/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.output;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;

public class FormatInfoRegistry {
    private static final Map FORMAT_INFO = new HashMap();
    private static final FormatInfoRegistry INSTANCE;

    public String getContentType(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        return ((FormatInfo)FORMAT_INFO.get(_format)).getContentType();
    }

    public JRExporter getExporter(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        JRExporter exporter = ((FormatInfo)FORMAT_INFO.get(_format)).getExporterInstance();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        return exporter;
    }

    public LayoutManager getLayoutManager(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        return ((FormatInfo)FORMAT_INFO.get(_format)).getLayoutManagerInstance();
    }

    private static void checkFormat(String _format) {
        if (!FORMAT_INFO.containsKey(_format)) {
            throw new IllegalArgumentException("Unsupported format: " + _format);
        }
    }

    public static FormatInfoRegistry getInstance() {
        return INSTANCE;
    }

    static {
        FORMAT_INFO.put("CSV", new FormatInfo("text/plain", JRCsvExporter.class, ClassicLayoutManager.class));
        FORMAT_INFO.put("HTML", new FormatInfo("text/html", JRHtmlExporter.class, ClassicLayoutManager.class));
        FORMAT_INFO.put("PDF", new FormatInfo("application/pdf", JRPdfExporter.class, ClassicLayoutManager.class));
        FORMAT_INFO.put("XLS", new FormatInfo("application/vnd.ms-excel", JRXlsExporter.class, ListLayoutManager.class));
        FORMAT_INFO.put("XML", new FormatInfo("text/xml", JRXmlExporter.class, ClassicLayoutManager.class));
        INSTANCE = new FormatInfoRegistry();
    }

    private static class FormatInfo {
        private String contentType;
        private Class exporterClass;
        private Class layoutManagerClass;

        private FormatInfo(String _contentType, Class _exporterClass, Class _layoutManagerClass) {
            this.contentType = _contentType;
            this.exporterClass = _exporterClass;
            this.layoutManagerClass = _layoutManagerClass;
        }

        public String getContentType() {
            return this.contentType;
        }

        public JRExporter getExporterInstance() {
            try {
                return (JRExporter)this.exporterClass.newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public LayoutManager getLayoutManagerInstance() {
            try {
                return (LayoutManager)this.layoutManagerClass.newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

