/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.DJChart;
import ar.com.fdvs.dj.domain.DJChartColors;
import ar.com.fdvs.dj.domain.DJChartOptions;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.entities.ColumnsGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class DJChartBuilder {
    private Byte type;
    private ColumnsGroup columnsGroup;
    private List columns = new ArrayList();
    private Byte operation;
    private DJChartOptions chartOptions;

    public DJChart build() throws ChartBuilderException {
        if (this.type == null) {
            throw new ChartBuilderException("Chart type must be specified");
        }
        if (this.columnsGroup == null) {
            throw new ChartBuilderException("The group to wich the chart is related must be specified");
        }
        if (this.columns.isEmpty()) {
            throw new ChartBuilderException("At least one column to wich the chart is related must be specified");
        }
        if (this.operation == null) {
            throw new ChartBuilderException("The operation for the chart must be specified");
        }
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        DJChart chart = new DJChart((byte)this.type, this.columnsGroup, this.columns, (byte)this.operation, this.chartOptions);
        return chart;
    }

    private DJChartOptions createDefaultOptions() {
        DJChartOptions options = new DJChartOptions(true, Color.white, 300, 300, true, 2, 0, 0, true, 1, DJChartColors.googleAnalytics());
        return options;
    }

    public DJChartBuilder addColumn(AbstractColumn column) {
        this.columns.add(column);
        return this;
    }

    public byte getOperation() {
        return this.operation;
    }

    public DJChartBuilder addOperation(byte operation) {
        this.operation = new Byte(operation);
        return this;
    }

    public byte getType() {
        return this.type;
    }

    public DJChartBuilder addType(byte type) {
        this.type = new Byte(type);
        return this;
    }

    public ColumnsGroup getColumnsGroup() {
        return this.columnsGroup;
    }

    public DJChartBuilder addColumnsGroup(ColumnsGroup columnsGroup) {
        this.columnsGroup = columnsGroup;
        return this;
    }

    public DJChartBuilder addParams(byte type, ColumnsGroup columnsGroup, AbstractColumn column, byte operation, DJChartOptions chartOptions) {
        return this.addType(type).addColumnsGroup(columnsGroup).addColumn(column).addOperation(operation).addChartOptions(chartOptions);
    }

    public DJChartOptions getChartOptions() {
        return this.chartOptions;
    }

    public DJChartBuilder addChartOptions(DJChartOptions chartOptions) {
        this.chartOptions = chartOptions;
        return this;
    }

    public DJChartBuilder setShowLegend(boolean showLegend) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setShowLegend(showLegend);
        return this;
    }

    public DJChartBuilder setBackColor(Color backColor) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setBackColor(backColor);
        return this;
    }

    public DJChartBuilder setHeight(int height) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setHeight(height);
        return this;
    }

    public DJChartBuilder setWidth(int width) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setWidth(width);
        return this;
    }

    public DJChartBuilder setCentered(boolean centered) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setCentered(centered);
        return this;
    }

    public DJChartBuilder setPosition(byte position) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setPosition(position);
        return this;
    }

    public DJChartBuilder setY(int y) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setY(y);
        return this;
    }

    public DJChartBuilder setX(int x) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setX(x);
        return this;
    }

    public DJChartBuilder setShowLabels(boolean showLabels) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setShowLabels(showLabels);
        return this;
    }

    public DJChartBuilder setBorder(byte border) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setBorder(border);
        return this;
    }

    public DJChartBuilder setColors(List colors) {
        if (this.chartOptions == null) {
            this.chartOptions = this.createDefaultOptions();
        }
        this.chartOptions.setColors(colors);
        return this;
    }
}

