/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.AutoTextExpressionUtils;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DynamicReport;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class CommonExpressionsHelper {
    private static String KEY_autotext_page = "autotext.page";
    private static String KEY_autotext_of = "autotext.of";
    private static String KEY_autotext_created_on = "autotext.created_on";

    public static void addPageXofY(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        pageNumber.setHorizontalAlignment((byte)3);
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression(KEY_autotext_page, KEY_autotext_of, true));
        pageNumber.setHeight(height);
        pageNumber.setWidth(80);
        pageNumber.setY(yOffset);
        pageNumber.setPositionType((byte)1);
        JRDesignTextField pageCounter = new JRDesignTextField();
        pageCounter.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("", "", false));
        pageCounter.setHeight(height);
        pageCounter.setWidth(30);
        pageCounter.setY(yOffset);
        pageCounter.setEvaluationTime((byte)2);
        pageCounter.setHorizontalAlignment((byte)1);
        pageCounter.setPositionType((byte)1);
        band.addElement((JRDesignElement)pageCounter);
        int pageNumberOffset = 0;
        HorizontalBandAlignment alignment = autoText.getAlignment();
        if (alignment == HorizontalBandAlignment.RIGHT) {
            pageNumberOffset = pageCounter.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageNumberOffset = -pageCounter.getWidth() / 2;
        }
        int pageCounterOffset = 0;
        if (alignment == HorizontalBandAlignment.LEFT) {
            pageCounterOffset = pageNumber.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageCounterOffset = pageNumber.getWidth() / 2;
        }
        alignment.align(report.getOptions().getPrintableWidth(), pageNumberOffset, band, (JRDesignElement)pageNumber);
        alignment.align(report.getOptions().getPrintableWidth(), pageCounterOffset, band, (JRDesignElement)pageCounter);
        band.setHeight(band.getHeight() + height);
    }

    public static void addPageXSlashY(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        pageNumber.setHorizontalAlignment((byte)3);
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("", "", false));
        pageNumber.setHeight(height);
        pageNumber.setWidth(20);
        pageNumber.setY(yOffset);
        JRDesignTextField pageCounter = new JRDesignTextField();
        pageCounter.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("/", "", false));
        pageCounter.setHeight(height);
        pageCounter.setWidth(20);
        pageCounter.setHorizontalAlignment((byte)1);
        pageCounter.setEvaluationTime((byte)2);
        pageCounter.setX(pageNumber.getX() + pageNumber.getWidth());
        pageCounter.setY(yOffset);
        int pageNumberOffset = 0;
        HorizontalBandAlignment alignment = autoText.getAlignment();
        if (alignment == HorizontalBandAlignment.RIGHT) {
            pageNumberOffset = pageCounter.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageNumberOffset = -pageCounter.getWidth() / 2;
        }
        int pageCounterOffset = 0;
        if (alignment == HorizontalBandAlignment.LEFT) {
            pageCounterOffset = pageNumber.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageCounterOffset = pageNumber.getWidth() / 2;
        }
        alignment.align(report.getOptions().getPrintableWidth(), pageNumberOffset, band, (JRDesignElement)pageNumber);
        alignment.align(report.getOptions().getPrintableWidth(), pageCounterOffset, band, (JRDesignElement)pageCounter);
        band.setHeight(band.getHeight() + height);
    }

    public static void addPageX(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        pageNumber.setHorizontalAlignment((byte)3);
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("", "", false));
        pageNumber.setHeight(height);
        pageNumber.setWidth(20);
        pageNumber.setY(yOffset);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)pageNumber);
        band.setHeight(band.getHeight() + height);
    }

    public static void addCreationDate(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField dateTf = new JRDesignTextField();
        dateTf.setExpression((JRExpression)AutoTextExpressionUtils.getDateExpression(KEY_autotext_created_on, "", report.getReportLocale(), autoText.getPattern()));
        dateTf.setHeight(height);
        dateTf.setWidth(report.getOptions().getColumnWidth());
        dateTf.setHorizontalAlignment(autoText.getAlignment().getAlignment());
        dateTf.setY(yOffset);
        dateTf.setPositionType((byte)1);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)dateTf);
        band.setHeight(band.getHeight() + height);
    }

    public static void addMessage(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField textfield = new JRDesignTextField();
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\"" + autoText.getMessageKey() + "\"");
        textfield.setExpression((JRExpression)expression);
        textfield.setHeight(autoText.getHeight().intValue());
        textfield.setStyledText(true);
        textfield.setWidth(report.getOptions().getPrintableWidth());
        textfield.setY(yOffset);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)textfield);
        textfield.setHorizontalAlignment(autoText.getAlignment().getAlignment());
        band.setHeight(band.getHeight() + height);
    }

    public static void add(int yOffset, JasperDesign design, DynamicReport report, JRDesignBand band, AutoText text) {
        switch (text.getType()) {
            case 0: {
                CommonExpressionsHelper.addPageXofY(yOffset, design, report, band, text);
                break;
            }
            case 1: {
                CommonExpressionsHelper.addPageXSlashY(yOffset, design, report, band, text);
                break;
            }
            case 2: {
                CommonExpressionsHelper.addPageX(yOffset, design, report, band, text);
                break;
            }
            case 3: {
                CommonExpressionsHelper.addCreationDate(yOffset, design, report, band, text);
                break;
            }
            case 4: {
                CommonExpressionsHelper.addMessage(yOffset, design, report, band, text);
            }
        }
    }
}

