package app.raybritton.tokenstorage

sealed class Optional<out T> {
    class Some<out T>(private val element: T): Optional<T>() {
        override fun get() = element
    }

    object None: Optional<Nothing>() {
        override fun get() = null
    }

    abstract fun get(): T?

    companion object {
        fun <T> auto(value: T?): Optional<T> {
            return if (value == null) {
                None
            } else {
                Some(value)
            }
        }
    }
}