package app.raybritton.tokenstorage.persistence

/**
 * A persistence class should store strings
 */
interface Persistence {
    /**
     * Remove all strings and ids
     */
    fun clearAll()

    /**
     * Remove the string with the matching key (if present)
     */
    fun clear(key: String)

    /**
     * Save the key and value
     */
    fun save(key: String, encrypted: String)

    /**
     * Load the string matching the key, null if none found
     */
    fun load(key: String): String?

    /**
     * Get all the keys stored
     */
    fun keys(): List<String>

    /**
     * True if the key has a value in storage
     */
    fun contains(key: String): Boolean

    /**
     * This only be called by TokenStorage
     */
    fun reset()
}