/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage.crypto;

import app.raybritton.tokenstorage.CryptoLogging;
import app.raybritton.tokenstorage.crypto.AesCbcWithIntegrity;
import app.raybritton.tokenstorage.crypto.Crypto;
import java.io.File;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lapp/raybritton/tokenstorage/crypto/PassphraseCrypto;", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "Lapp/raybritton/tokenstorage/CryptoLogging;", "saltDir", "Ljava/io/File;", "saltFilename", "", "(Ljava/io/File;Ljava/lang/String;)V", "value", "passphrase", "getPassphrase", "()Ljava/lang/String;", "setPassphrase", "(Ljava/lang/String;)V", "salt", "getSalt", "salt$delegate", "Lkotlin/Lazy;", "secretKeys", "Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$SecretKeys;", "decrypt", "encrypted", "encrypt", "plaintext", "invalidate", "", "reset", "verify", "core_release"})
public final class PassphraseCrypto
implements Crypto,
CryptoLogging {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private AesCbcWithIntegrity.SecretKeys secretKeys;
    @Nullable
    private String passphrase;
    private final Lazy salt$delegate;
    private final File saltDir;
    private final String saltFilename;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PassphraseCrypto.class), "salt", "getSalt()Ljava/lang/String;"))};
    }

    @Nullable
    public final String getPassphrase() {
        return this.passphrase;
    }

    public final void setPassphrase(@Nullable String value) {
        this.fine("passphrase set to " + value);
        if (Intrinsics.areEqual((Object)this.passphrase, (Object)value)) {
            return;
        }
        this.passphrase = value;
        this.invalidate();
    }

    private final String getSalt() {
        Lazy lazy = this.salt$delegate;
        PassphraseCrypto passphraseCrypto = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    private final void invalidate() {
        this.fine("invalidate()");
        if (this.passphrase == null) {
            this.secretKeys = null;
        } else {
            String string = this.passphrase;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.secretKeys = AesCbcWithIntegrity.INSTANCE.generateKeyFromPassword(string, this.getSalt());
        }
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        this.fine("encrypt(" + plaintext + ')');
        AesCbcWithIntegrity.SecretKeys secretKeys = this.secretKeys;
        if (secretKeys == null) {
            Intrinsics.throwNpe();
        }
        return AesCbcWithIntegrity.encrypt$default(AesCbcWithIntegrity.INSTANCE, plaintext, secretKeys, null, 4, null).toString();
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encrypted) {
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        this.fine("decrypt(" + encrypted + ')');
        AesCbcWithIntegrity.CipherTextIvMac mac = new AesCbcWithIntegrity.CipherTextIvMac(encrypted);
        AesCbcWithIntegrity.SecretKeys secretKeys = this.secretKeys;
        if (secretKeys == null) {
            Intrinsics.throwNpe();
        }
        byte[] byArray = AesCbcWithIntegrity.INSTANCE.decrypt(mac, secretKeys);
        return new String(byArray, Charsets.UTF_8);
    }

    @Override
    public void reset() {
        this.fine("reset()");
        new File(this.saltDir, this.saltFilename).delete();
    }

    @Override
    public void verify() {
        this.fine("verify()");
        if (this.passphrase == null || this.secretKeys == null) {
            throw (Throwable)new IllegalStateException("passphrase must be set before use");
        }
        CharSequence charSequence = this.passphrase;
        if (charSequence == null || charSequence.length() == 0) {
            throw (Throwable)new IllegalStateException("passphrase must have content");
        }
    }

    public PassphraseCrypto(@NotNull File saltDir, @NotNull String saltFilename) {
        Intrinsics.checkParameterIsNotNull((Object)saltDir, (String)"saltDir");
        Intrinsics.checkParameterIsNotNull((Object)saltFilename, (String)"saltFilename");
        this.saltDir = saltDir;
        this.saltFilename = saltFilename;
        this.salt$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PassphraseCrypto this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                String string;
                this.this$0.fine("salt creation");
                File saltFile = new File(PassphraseCrypto.access$getSaltDir$p(this.this$0), PassphraseCrypto.access$getSaltFilename$p(this.this$0));
                if (saltFile.exists()) {
                    string = (String)FilesKt.readLines$default((File)saltFile, null, (int)1, null).get(0);
                } else {
                    void var2_2;
                    String string2 = UUID.randomUUID().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
                    String newSalt = string2;
                    FilesKt.writeText$default((File)saltFile, (String)newSalt, null, (int)2, null);
                    string = var2_2;
                }
                return string;
            }
            {
                this.this$0 = passphraseCrypto;
                super(0);
            }
        }));
    }

    public /* synthetic */ PassphraseCrypto(File file, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "crypto-salt";
        }
        this(file, string);
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.debug(this, message);
    }

    @Override
    public void fine(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.fine(this, message);
    }

    @Override
    @NotNull
    public String logPrefix() {
        return CryptoLogging.DefaultImpls.logPrefix(this);
    }

    public static final /* synthetic */ File access$getSaltDir$p(PassphraseCrypto $this) {
        return $this.saltDir;
    }

    public static final /* synthetic */ String access$getSaltFilename$p(PassphraseCrypto $this) {
        return $this.saltFilename;
    }
}

