package app.raybritton.tokenstorage

/**
 * This provides an object that represents a single stored string
 *
 * It's main purpose is for helping with patterns like DI
 */
class TokenWrapper(private val tokenStorage: TokenStorage<*,*,*>,
                   val key: String) {
    fun save(plaintext: String) {
        tokenStorage.save(key, plaintext)
    }

    fun load(): String? {
        return tokenStorage.load(key)
    }

    fun isSet(): Boolean {
        return tokenStorage.contains(key)
    }

    fun clear() {
        tokenStorage.clear(key)
    }
}