package app.raybritton.tokenstorage.persistence

import java.io.File
import java.io.FileInputStream
import java.io.FileOutputStream
import java.io.IOException
import java.io.ObjectInputStream
import java.io.ObjectOutputStream
import java.io.Serializable

class BinaryFilePersistence(dir: File,
                            filename: String = "crypto.bin") : NoRandomAccessPersistence() {
    private var file = File(dir, filename)

    override fun write(data: Map<String, String>) {
        val output = ObjectOutputStream(FileOutputStream(file))
        output.writeObject(mapToElements(data))
        output.close()
    }

    override fun read(): Map<String, String> {
        if (!file.exists()) {
            return mapOf()
        }
        val fis = ObjectInputStream(FileInputStream(file))
        val data = elementsToMap(fis.readObject() as? Array<DataElement>)
        fis.close()
        return data
    }

    override fun reset() {
        super.reset()
        file.delete()
    }

    private fun mapToElements(data: Map<String, String>): Array<DataElement> {
        val dataList = data.entries.toList()
        return Array(data.size, { DataElement(dataList[it].key, dataList[it].value) })
    }

    private fun elementsToMap(data: Array<DataElement>?): Map<String, String> {
        if (data == null) {
            throw IOException("Binary file data corrupted")
        }
        return data.map { it.key to it.value }.toMap()
    }

    private data class DataElement(val key: String, val value: String) : Serializable
}
