package app.raybritton.tokenstorage

class TokenWrapper(private val tokenStorage: TokenStorage,
                   val key: String) {
    fun save(plaintext: String) {
        tokenStorage.save(key, plaintext)
    }

    fun load(): String? {
        return tokenStorage.load(key)
    }

    fun isSet(): Boolean {
        return tokenStorage.contains(key)
    }

    fun clear() {
        tokenStorage.clear(key)
    }
}