/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.datasource.AbstractDatabaseConnectionSource;
import us.fatehi.utility.datasource.PooledConnectionUtility;
import us.fatehi.utility.datasource.UserCredentials;

final class SingleDatabaseConnectionSource
extends AbstractDatabaseConnectionSource {
    private final Connection connection;

    @Deprecated
    SingleDatabaseConnectionSource(Connection connection, Consumer<Connection> connectionInitializer) {
        try {
            this.connection = DatabaseUtility.checkConnection(connection);
            this.setConnectionInitializer(connectionInitializer);
            this.connectionInitializer.accept(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not wrap provided database connection", e);
        }
    }

    SingleDatabaseConnectionSource(String connectionUrl, Map<String, String> connectionProperties, UserCredentials userCredentials, Consumer<Connection> connectionInitializer) {
        Utility.requireNotBlank(connectionUrl, "No database connection URL provided");
        Objects.requireNonNull(userCredentials, "No user credentials provided");
        String user = userCredentials.getUser();
        String password = userCredentials.getPassword();
        Properties jdbcConnectionProperties = SingleDatabaseConnectionSource.createConnectionProperties(connectionUrl, connectionProperties, user, password);
        this.connection = SingleDatabaseConnectionSource.getConnection(connectionUrl, jdbcConnectionProperties, connectionInitializer);
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    @Override
    public Connection get() {
        return PooledConnectionUtility.newPooledConnection(this.connection, this);
    }

    @Override
    public boolean releaseConnection(Connection connection) {
        return true;
    }

    protected void finalize() throws Throwable {
        if (!this.connection.isClosed()) {
            throw new RuntimeException("Connection pool is not closed");
        }
        super.finalize();
    }
}

