/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import schemacrawler.loader.attributes.model.CatalogAttributes;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import us.fatehi.utility.ioresource.InputResource;

public class CatalogAttributesUtility {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CatalogAttributes readCatalogAttributes(InputResource inputResource) {
        Objects.requireNonNull(inputResource, "No input resource provided");
        try (Reader reader = inputResource.openNewInputReader(StandardCharsets.UTF_8);){
            CatalogAttributes catalogAttributes;
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            CatalogAttributes catalogAttributes2 = catalogAttributes = (CatalogAttributes)mapper.readValue(reader, CatalogAttributes.class);
            return catalogAttributes2;
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot read catalog attributes", e);
        }
    }

    private CatalogAttributesUtility() {
    }
}

