/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.circular;

import de.danielbechler.diff.path.NodePath;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Objects;
import java.util.LinkedList;

public class CircularReferenceDetector {
    private final LinkedList<Entry> stack = new LinkedList();
    private ReferenceMatchingMode referenceMatchingMode = ReferenceMatchingMode.EQUALITY_OPERATOR;

    public CircularReferenceDetector(ReferenceMatchingMode referenceMatchingMode) {
        Assert.notNull((Object)referenceMatchingMode, "referenceMatchingMode");
        this.referenceMatchingMode = referenceMatchingMode;
    }

    public void push(Object instance, NodePath nodePath) {
        if (instance == null) {
            return;
        }
        if (this.knows(instance)) {
            throw new CircularReferenceException(this.entryForInstance(instance).getNodePath());
        }
        Entry entry = new Entry(nodePath, instance);
        this.stack.addLast(entry);
    }

    public boolean knows(Object needle) {
        for (Entry entry : this.stack) {
            Object instance = entry.getInstance();
            if (!this.isMatch(needle, instance)) continue;
            return true;
        }
        return false;
    }

    private Entry entryForInstance(Object instance) {
        for (Entry entry : this.stack) {
            if (!this.isMatch(instance, entry.getInstance())) continue;
            return entry;
        }
        return null;
    }

    protected boolean isMatch(Object anObject, Object anotherObject) {
        if (this.referenceMatchingMode == ReferenceMatchingMode.EQUALITY_OPERATOR) {
            return anotherObject == anObject;
        }
        if (this.referenceMatchingMode == ReferenceMatchingMode.EQUALS_METHOD) {
            return anotherObject == anObject || Objects.isEqual(anObject, anotherObject);
        }
        throw new IllegalStateException("Missing reference matching mode");
    }

    public void remove(Object instance) {
        if (instance == null) {
            return;
        }
        if (!this.isMatch(instance, this.stack.getLast().getInstance())) {
            throw new IllegalArgumentException("Detected inconsistency in enter/leave sequence. Must always be LIFO.");
        }
        this.stack.removeLast();
    }

    public int size() {
        return this.stack.size();
    }

    public static class CircularReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final NodePath nodePath;

        public CircularReferenceException(NodePath nodePath) {
            this.nodePath = nodePath;
        }

        public NodePath getNodePath() {
            return this.nodePath;
        }

        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class Entry {
        private final NodePath nodePath;
        private final Object instance;

        private Entry(NodePath nodePath, Object instance) {
            this.nodePath = nodePath;
            this.instance = instance;
        }

        public NodePath getNodePath() {
            return this.nodePath;
        }

        public Object getInstance() {
            return this.instance;
        }

        public String toString() {
            return this.nodePath.toString() + "{" + this.instance.toString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceMatchingMode {
        EQUALITY_OPERATOR,
        EQUALS_METHOD;

    }
}

