/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionAdapter;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionResolver;
import org.apache.tools.ant.taskdefs.optional.extension.ExtensionUtil;
import org.apache.tools.ant.taskdefs.optional.extension.resolvers.AntResolver;
import org.apache.tools.ant.taskdefs.optional.extension.resolvers.LocationResolver;
import org.apache.tools.ant.taskdefs.optional.extension.resolvers.URLResolver;

public class JarLibResolveTask
extends Task {
    private String m_property;
    private Extension m_extension;
    private final ArrayList m_resolvers = new ArrayList();
    private boolean m_checkExtension = true;
    private boolean m_failOnError = true;

    public void setProperty(String property) {
        this.m_property = property;
    }

    public void setCheckExtension(boolean checkExtension) {
        this.m_checkExtension = checkExtension;
    }

    public void setFailOnError(boolean failOnError) {
        this.m_failOnError = failOnError;
    }

    public void addConfiguredLocation(LocationResolver location) {
        this.m_resolvers.add(location);
    }

    public void addConfiguredUrl(URLResolver url) {
        this.m_resolvers.add(url);
    }

    public void addConfiguredAnt(AntResolver ant) {
        this.m_resolvers.add(ant);
    }

    public void addConfiguredExtension(ExtensionAdapter extension) {
        if (null != this.m_extension) {
            String message = "Can not specify extension to resolve multiple times.";
            throw new BuildException("Can not specify extension to resolve multiple times.");
        }
        this.m_extension = extension.toExtension();
    }

    public void execute() throws BuildException {
        this.validate();
        this.getProject().log("Resolving extension: " + this.m_extension, 3);
        String candidate = this.getProject().getProperty(this.m_property);
        if (null != candidate) {
            String message = "Property Already set to: " + candidate;
            if (this.m_failOnError) {
                throw new BuildException(message);
            }
            this.getProject().log(message, 0);
            return;
        }
        int size = this.m_resolvers.size();
        int i = 0;
        while (i < size) {
            ExtensionResolver resolver = (ExtensionResolver)this.m_resolvers.get(i);
            this.getProject().log("Searching for extension using Resolver:" + resolver, 3);
            try {
                File file = resolver.resolve(this.m_extension, this.getProject());
                try {
                    this.checkExtension(file);
                    return;
                }
                catch (BuildException be) {
                    String message = "File " + file + " returned by resolver failed " + "to satisfy extension due to: " + be.getMessage();
                    this.getProject().log(message, 1);
                }
            }
            catch (BuildException be) {
                String message = "Failed to resolve extension to file using resolver " + resolver + " due to: " + (Object)((Object)be);
                this.getProject().log(message, 1);
            }
            ++i;
        }
        this.missingExtension();
    }

    private void missingExtension() {
        String message = "Unable to resolve extension to a file";
        if (this.m_failOnError) {
            throw new BuildException("Unable to resolve extension to a file");
        }
        this.getProject().log("Unable to resolve extension to a file", 0);
    }

    private void checkExtension(File file) {
        if (!file.exists()) {
            String message = "File " + file + " does not exist";
            throw new BuildException(message);
        }
        if (!file.isFile()) {
            String message = "File " + file + " is not a file";
            throw new BuildException(message);
        }
        if (this.m_checkExtension) {
            this.getProject().log("Checking file " + file + " to see if it satisfies extension", 3);
            Manifest manifest = ExtensionUtil.getManifest(file);
            Extension[] extensions = Extension.getAvailable(manifest);
            int i = 0;
            while (i < extensions.length) {
                Extension extension = extensions[i];
                if (extension.isCompatibleWith(this.m_extension)) {
                    this.setLibraryProperty(file);
                    return;
                }
                ++i;
            }
            this.getProject().log("File " + file + " skipped as it " + "does not satisfy extension", 3);
            String message = "File " + file + " does not satisfy extension";
            throw new BuildException(message);
        }
        String message = "Setting property to " + file + " without verifying library satisfies extension";
        this.getProject().log(message, 3);
        this.setLibraryProperty(file);
    }

    private void setLibraryProperty(File file) {
        this.getProject().setNewProperty(this.m_property, file.getAbsolutePath());
    }

    private void validate() throws BuildException {
        if (null == this.m_property) {
            String message = "Property attribute must be specified.";
            throw new BuildException("Property attribute must be specified.");
        }
        if (null == this.m_extension) {
            String message = "Extension element must be specified.";
            throw new BuildException("Extension element must be specified.");
        }
    }
}

