/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import androidx.annotation.RestrictTo;
import androidx.work.Configuration;
import androidx.work.ExistingWorkPolicy;
import androidx.work.Operation;
import androidx.work.WorkInfo;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.impl.OperationImpl;
import androidx.work.impl.Processor;
import androidx.work.impl.Scheduler;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.WorkerUpdater;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.model.WorkTagDao;
import androidx.work.impl.utils.EnqueueRunnable;
import androidx.work.impl.utils.EnqueueUtilsKt;
import androidx.work.impl.utils.futures.SettableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a8\u0006\u001b"}, d2={"updateWorkImpl", "Landroidx/work/WorkManager$UpdateResult;", "processor", "Landroidx/work/impl/Processor;", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "configuration", "Landroidx/work/Configuration;", "schedulers", "", "Landroidx/work/impl/Scheduler;", "newWorkSpec", "Landroidx/work/impl/model/WorkSpec;", "tags", "", "", "enqueueUniquelyNamedPeriodic", "Landroidx/work/Operation;", "Landroidx/work/impl/WorkManagerImpl;", "name", "workRequest", "Landroidx/work/WorkRequest;", "failWorkTypeChanged", "", "Landroidx/work/impl/OperationImpl;", "message", "Lcom/google/common/util/concurrent/ListenableFuture;", "work-runtime_release"})
@JvmName(name="WorkerUpdater")
@SourceDebugExtension(value={"SMAP\nWorkerUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerUpdater.kt\nandroidx/work/impl/WorkerUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1855#2,2:171\n*S KotlinDebug\n*F\n+ 1 WorkerUpdater.kt\nandroidx/work/impl/WorkerUpdater\n*L\n55#1:171,2\n*E\n"})
public final class WorkerUpdater {
    private static final WorkManager.UpdateResult updateWorkImpl(Processor processor, WorkDatabase workDatabase, Configuration configuration, List<? extends Scheduler> schedulers2, WorkSpec newWorkSpec, Set<String> tags) {
        String workSpecId = newWorkSpec.id;
        WorkSpec workSpec = workDatabase.workSpecDao().getWorkSpec(workSpecId);
        if (workSpec == null) {
            throw new IllegalArgumentException("Worker with " + workSpecId + " doesn't exist");
        }
        WorkSpec oldWorkSpec = workSpec;
        if (oldWorkSpec.state.isFinished()) {
            return WorkManager.UpdateResult.NOT_APPLIED;
        }
        if (oldWorkSpec.isPeriodic() ^ newWorkSpec.isPeriodic()) {
            Function1 type2 = updateWorkImpl.type.1.INSTANCE;
            throw new UnsupportedOperationException("Can't update " + (String)type2.invoke((Object)oldWorkSpec) + " Worker to " + (String)type2.invoke((Object)newWorkSpec) + " Worker. Update operation must preserve worker's type.");
        }
        boolean isEnqueued = processor.isEnqueued(workSpecId);
        if (!isEnqueued) {
            Iterable $this$forEach$iv = schedulers2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Scheduler scheduler = (Scheduler)element$iv;
                boolean bl = false;
                scheduler.cancel(workSpecId);
            }
        }
        workDatabase.runInTransaction(() -> WorkerUpdater.updateWorkImpl$lambda$2(workDatabase, oldWorkSpec, newWorkSpec, schedulers2, workSpecId, tags, isEnqueued));
        if (!isEnqueued) {
            Schedulers.schedule(configuration, workDatabase, schedulers2);
        }
        return isEnqueued ? WorkManager.UpdateResult.APPLIED_FOR_NEXT_RUN : WorkManager.UpdateResult.APPLIED_IMMEDIATELY;
    }

    @NotNull
    public static final ListenableFuture<WorkManager.UpdateResult> updateWorkImpl(@NotNull WorkManagerImpl $this$updateWorkImpl, @NotNull WorkRequest workRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$updateWorkImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)workRequest, (String)"workRequest");
        SettableFuture future = SettableFuture.create();
        $this$updateWorkImpl.getWorkTaskExecutor().getSerialTaskExecutor().execute(() -> WorkerUpdater.updateWorkImpl$lambda$3(future, $this$updateWorkImpl, workRequest));
        Intrinsics.checkNotNullExpressionValue(future, (String)"future");
        return future;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final Operation enqueueUniquelyNamedPeriodic(@NotNull WorkManagerImpl $this$enqueueUniquelyNamedPeriodic, @NotNull String name, @NotNull WorkRequest workRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$enqueueUniquelyNamedPeriodic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)workRequest, (String)"workRequest");
        OperationImpl operation = new OperationImpl();
        Function0 enqueueNew2 = (Function0)new Function0<Unit>(workRequest, $this$enqueueUniquelyNamedPeriodic, name, operation){
            final /* synthetic */ WorkRequest $workRequest;
            final /* synthetic */ WorkManagerImpl $this_enqueueUniquelyNamedPeriodic;
            final /* synthetic */ String $name;
            final /* synthetic */ OperationImpl $operation;
            {
                this.$workRequest = $workRequest;
                this.$this_enqueueUniquelyNamedPeriodic = $receiver;
                this.$name = $name;
                this.$operation = $operation;
                super(0);
            }

            public final void invoke() {
                List requests = CollectionsKt.listOf((Object)this.$workRequest);
                WorkContinuationImpl continuation = new WorkContinuationImpl(this.$this_enqueueUniquelyNamedPeriodic, this.$name, ExistingWorkPolicy.KEEP, requests);
                new EnqueueRunnable(continuation, this.$operation).run();
            }
        };
        $this$enqueueUniquelyNamedPeriodic.getWorkTaskExecutor().getSerialTaskExecutor().execute(() -> WorkerUpdater.enqueueUniquelyNamedPeriodic$lambda$4($this$enqueueUniquelyNamedPeriodic, name, operation, enqueueNew2, workRequest));
        return operation;
    }

    private static final void failWorkTypeChanged(OperationImpl $this$failWorkTypeChanged, String message) {
        $this$failWorkTypeChanged.markState(new Operation.State.FAILURE(new UnsupportedOperationException(message)));
    }

    private static final void updateWorkImpl$lambda$2(WorkDatabase $workDatabase, WorkSpec $oldWorkSpec, WorkSpec $newWorkSpec, List $schedulers, String $workSpecId, Set $tags, boolean $isEnqueued) {
        Intrinsics.checkNotNullParameter((Object)((Object)$workDatabase), (String)"$workDatabase");
        Intrinsics.checkNotNullParameter((Object)$oldWorkSpec, (String)"$oldWorkSpec");
        Intrinsics.checkNotNullParameter((Object)$newWorkSpec, (String)"$newWorkSpec");
        Intrinsics.checkNotNullParameter((Object)$schedulers, (String)"$schedulers");
        Intrinsics.checkNotNullParameter((Object)$workSpecId, (String)"$workSpecId");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        WorkSpecDao workSpecDao = $workDatabase.workSpecDao();
        WorkTagDao workTagDao = $workDatabase.workTagDao();
        Object object = $oldWorkSpec.state;
        int n = $oldWorkSpec.runAttemptCount;
        long l = $oldWorkSpec.lastEnqueueTime;
        int n2 = $oldWorkSpec.getGeneration() + 1;
        int n3 = $oldWorkSpec.getPeriodCount();
        long l2 = $oldWorkSpec.getNextScheduleTimeOverride();
        int n4 = $oldWorkSpec.getNextScheduleTimeOverrideGeneration();
        Object $this$updateWorkImpl_u24lambda_u242_u24lambda_u241 = object = WorkSpec.copy$default($newWorkSpec, null, (WorkInfo.State)((Object)object), null, null, null, null, 0L, 0L, 0L, null, n, null, 0L, l, 0L, 0L, false, null, n3, n2, l2, n4, 252925, null);
        boolean bl = false;
        if ($newWorkSpec.getNextScheduleTimeOverrideGeneration() == 1) {
            ((WorkSpec)$this$updateWorkImpl_u24lambda_u242_u24lambda_u241).setNextScheduleTimeOverride($newWorkSpec.getNextScheduleTimeOverride());
            ((WorkSpec)$this$updateWorkImpl_u24lambda_u242_u24lambda_u241).setNextScheduleTimeOverrideGeneration(((WorkSpec)$this$updateWorkImpl_u24lambda_u242_u24lambda_u241).getNextScheduleTimeOverrideGeneration() + 1);
        }
        Object updatedSpec = object;
        workSpecDao.updateWorkSpec(EnqueueUtilsKt.wrapInConstraintTrackingWorkerIfNeeded($schedulers, (WorkSpec)updatedSpec));
        workTagDao.deleteByWorkSpecId($workSpecId);
        workTagDao.insertTags($workSpecId, $tags);
        if (!$isEnqueued) {
            workSpecDao.markWorkSpecScheduled($workSpecId, -1L);
            $workDatabase.workProgressDao().delete($workSpecId);
        }
    }

    private static final void updateWorkImpl$lambda$3(SettableFuture $future, WorkManagerImpl $this_updateWorkImpl, WorkRequest $workRequest) {
        Intrinsics.checkNotNullParameter((Object)$this_updateWorkImpl, (String)"$this_updateWorkImpl");
        Intrinsics.checkNotNullParameter((Object)$workRequest, (String)"$workRequest");
        if ($future.isCancelled()) {
            return;
        }
        try {
            Processor processor = $this_updateWorkImpl.getProcessor();
            Intrinsics.checkNotNullExpressionValue((Object)processor, (String)"processor");
            WorkDatabase workDatabase = $this_updateWorkImpl.getWorkDatabase();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workDatabase");
            Configuration configuration = $this_updateWorkImpl.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            List<Scheduler> list = $this_updateWorkImpl.getSchedulers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"schedulers");
            WorkManager.UpdateResult result = WorkerUpdater.updateWorkImpl(processor, workDatabase, configuration, list, $workRequest.getWorkSpec(), $workRequest.getTags());
            $future.set(result);
        }
        catch (Throwable e) {
            $future.setException(e);
        }
    }

    private static final void enqueueUniquelyNamedPeriodic$lambda$4(WorkManagerImpl $this_enqueueUniquelyNamedPeriodic, String $name, OperationImpl $operation, Function0 $enqueueNew, WorkRequest $workRequest) {
        Intrinsics.checkNotNullParameter((Object)$this_enqueueUniquelyNamedPeriodic, (String)"$this_enqueueUniquelyNamedPeriodic");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)$enqueueNew, (String)"$enqueueNew");
        Intrinsics.checkNotNullParameter((Object)$workRequest, (String)"$workRequest");
        WorkSpecDao workSpecDao = $this_enqueueUniquelyNamedPeriodic.getWorkDatabase().workSpecDao();
        List<WorkSpec.IdAndState> idAndStates = workSpecDao.getWorkSpecIdAndStatesForName($name);
        if (idAndStates.size() > 1) {
            WorkerUpdater.failWorkTypeChanged($operation, "Can't apply UPDATE policy to the chains of work.");
            return;
        }
        WorkSpec.IdAndState current = (WorkSpec.IdAndState)CollectionsKt.firstOrNull(idAndStates);
        if (current == null) {
            $enqueueNew.invoke();
            return;
        }
        WorkSpec spec = workSpecDao.getWorkSpec(current.id);
        if (spec == null) {
            $operation.markState(new Operation.State.FAILURE(new IllegalStateException("WorkSpec with " + current.id + ", that matches a name \"" + $name + "\", wasn't found")));
            return;
        }
        if (!spec.isPeriodic()) {
            WorkerUpdater.failWorkTypeChanged($operation, "Can't update OneTimeWorker to Periodic Worker. Update operation must preserve worker's type.");
            return;
        }
        if (current.state == WorkInfo.State.CANCELLED) {
            workSpecDao.delete(current.id);
            $enqueueNew.invoke();
            return;
        }
        WorkSpec newWorkSpec = WorkSpec.copy$default($workRequest.getWorkSpec(), current.id, null, null, null, null, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 0L, 0, 0x3FFFFE, null);
        try {
            Processor processor = $this_enqueueUniquelyNamedPeriodic.getProcessor();
            Intrinsics.checkNotNullExpressionValue((Object)processor, (String)"processor");
            WorkDatabase workDatabase = $this_enqueueUniquelyNamedPeriodic.getWorkDatabase();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workDatabase");
            Configuration configuration = $this_enqueueUniquelyNamedPeriodic.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
            List<Scheduler> list = $this_enqueueUniquelyNamedPeriodic.getSchedulers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"schedulers");
            WorkerUpdater.updateWorkImpl(processor, workDatabase, configuration, list, newWorkSpec, $workRequest.getTags());
            $operation.markState(Operation.SUCCESS);
        }
        catch (Throwable e) {
            $operation.markState(new Operation.State.FAILURE(e));
        }
    }
}

