/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.DurationApi26Impl;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\r\b&\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Landroidx/work/WorkRequest;", "", "id", "Ljava/util/UUID;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "tags", "", "", "(Ljava/util/UUID;Landroidx/work/impl/model/WorkSpec;Ljava/util/Set;)V", "getId", "()Ljava/util/UUID;", "stringId", "getStringId", "()Ljava/lang/String;", "getTags", "()Ljava/util/Set;", "getWorkSpec", "()Landroidx/work/impl/model/WorkSpec;", "Builder", "Companion", "work-runtime_release"})
public abstract class WorkRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private final WorkSpec workSpec;
    @NotNull
    private final Set<String> tags;
    public static final long DEFAULT_BACKOFF_DELAY_MILLIS = 30000L;
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MAX_BACKOFF_MILLIS = 18000000L;
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MIN_BACKOFF_MILLIS = 10000L;

    public WorkRequest(@NotNull UUID id, @NotNull WorkSpec workSpec, @NotNull Set<String> tags) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.id = id;
        this.workSpec = workSpec;
        this.tags = tags;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final WorkSpec getWorkSpec() {
        return this.workSpec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final Set<String> getTags() {
        return this.tags;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final String getStringId() {
        String string = this.getId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0000*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004B\u0017\b\u0000\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010%\u001a\u00028\u00002\u0006\u0010&\u001a\u00020\u0017\u00a2\u0006\u0002\u0010'J\u000b\u0010(\u001a\u00028\u0001\u00a2\u0006\u0002\u0010)J\u000f\u0010*\u001a\u00028\u0001H \u00a2\u0006\u0004\b+\u0010)J\u0015\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\u0010/J\u001b\u0010,\u001a\u00028\u00002\u0006\u0010-\u001a\u0002002\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00103J\u001d\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\u00107J#\u00104\u001a\u00028\u00002\u0006\u00105\u001a\u0002062\u0006\u00108\u001a\u0002002\u0006\u00101\u001a\u000202\u00a2\u0006\u0002\u00109J\u0013\u0010:\u001a\u00028\u00002\u0006\u0010;\u001a\u00020<\u00a2\u0006\u0002\u0010=J\u0015\u0010>\u001a\u00028\u00002\u0006\u0010?\u001a\u00020@H\u0017\u00a2\u0006\u0002\u0010AJ\u0013\u0010B\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010CJ\u0015\u0010D\u001a\u00028\u00002\u0006\u0010-\u001a\u00020.H\u0017\u00a2\u0006\u0002\u0010/J\u001d\u0010D\u001a\u00028\u00002\u0006\u0010-\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0002\u00103J\u0015\u0010E\u001a\u00028\u00002\u0006\u0010F\u001a\u00020GH\u0007\u00a2\u0006\u0002\u0010HJ\u0015\u0010I\u001a\u00028\u00002\u0006\u0010J\u001a\u00020KH\u0007\u00a2\u0006\u0002\u0010LJ\u0013\u0010M\u001a\u00028\u00002\u0006\u0010N\u001a\u00020O\u00a2\u0006\u0002\u0010PJ\u001d\u0010Q\u001a\u00028\u00002\u0006\u0010R\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007\u00a2\u0006\u0002\u00103J\u001d\u0010S\u001a\u00028\u00002\u0006\u0010T\u001a\u0002002\u0006\u00101\u001a\u000202H\u0007\u00a2\u0006\u0002\u00103R\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u00028\u0000X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006U"}, d2={"Landroidx/work/WorkRequest$Builder;", "B", "W", "Landroidx/work/WorkRequest;", "", "workerClass", "Ljava/lang/Class;", "Landroidx/work/ListenableWorker;", "(Ljava/lang/Class;)V", "backoffCriteriaSet", "", "getBackoffCriteriaSet$work_runtime_release", "()Z", "setBackoffCriteriaSet$work_runtime_release", "(Z)V", "id", "Ljava/util/UUID;", "getId$work_runtime_release", "()Ljava/util/UUID;", "setId$work_runtime_release", "(Ljava/util/UUID;)V", "tags", "", "", "getTags$work_runtime_release", "()Ljava/util/Set;", "thisObject", "getThisObject$work_runtime_release", "()Landroidx/work/WorkRequest$Builder;", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "getWorkSpec$work_runtime_release", "()Landroidx/work/impl/model/WorkSpec;", "setWorkSpec$work_runtime_release", "(Landroidx/work/impl/model/WorkSpec;)V", "getWorkerClass$work_runtime_release", "()Ljava/lang/Class;", "addTag", "tag", "(Ljava/lang/String;)Landroidx/work/WorkRequest$Builder;", "build", "()Landroidx/work/WorkRequest;", "buildInternal", "buildInternal$work_runtime_release", "keepResultsForAtLeast", "duration", "Ljava/time/Duration;", "(Ljava/time/Duration;)Landroidx/work/WorkRequest$Builder;", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Landroidx/work/WorkRequest$Builder;", "setBackoffCriteria", "backoffPolicy", "Landroidx/work/BackoffPolicy;", "(Landroidx/work/BackoffPolicy;Ljava/time/Duration;)Landroidx/work/WorkRequest$Builder;", "backoffDelay", "(Landroidx/work/BackoffPolicy;JLjava/util/concurrent/TimeUnit;)Landroidx/work/WorkRequest$Builder;", "setConstraints", "constraints", "Landroidx/work/Constraints;", "(Landroidx/work/Constraints;)Landroidx/work/WorkRequest$Builder;", "setExpedited", "policy", "Landroidx/work/OutOfQuotaPolicy;", "(Landroidx/work/OutOfQuotaPolicy;)Landroidx/work/WorkRequest$Builder;", "setId", "(Ljava/util/UUID;)Landroidx/work/WorkRequest$Builder;", "setInitialDelay", "setInitialRunAttemptCount", "runAttemptCount", "", "(I)Landroidx/work/WorkRequest$Builder;", "setInitialState", "state", "Landroidx/work/WorkInfo$State;", "(Landroidx/work/WorkInfo$State;)Landroidx/work/WorkRequest$Builder;", "setInputData", "inputData", "Landroidx/work/Data;", "(Landroidx/work/Data;)Landroidx/work/WorkRequest$Builder;", "setLastEnqueueTime", "lastEnqueueTime", "setScheduleRequestedAt", "scheduleRequestedAt", "work-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nWorkRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkRequest.kt\nandroidx/work/WorkRequest$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1#2:356\n*E\n"})
    public static abstract class Builder<B extends Builder<B, ?>, W extends WorkRequest> {
        @NotNull
        private final Class<? extends ListenableWorker> workerClass;
        private boolean backoffCriteriaSet;
        @NotNull
        private UUID id;
        @NotNull
        private WorkSpec workSpec;
        @NotNull
        private final Set<String> tags;

        public Builder(@NotNull Class<? extends ListenableWorker> workerClass) {
            Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
            this.workerClass = workerClass;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            this.id = uUID;
            String string = this.id.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
            String string2 = this.workerClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"workerClass.name");
            this.workSpec = new WorkSpec(string, string2);
            Object[] objectArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.workerClass.getName(), (String)"workerClass.name");
            this.tags = SetsKt.mutableSetOf((Object[])objectArray);
        }

        @NotNull
        public final Class<? extends ListenableWorker> getWorkerClass$work_runtime_release() {
            return this.workerClass;
        }

        public final boolean getBackoffCriteriaSet$work_runtime_release() {
            return this.backoffCriteriaSet;
        }

        public final void setBackoffCriteriaSet$work_runtime_release(boolean bl) {
            this.backoffCriteriaSet = bl;
        }

        @NotNull
        public final UUID getId$work_runtime_release() {
            return this.id;
        }

        public final void setId$work_runtime_release(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.id = uUID;
        }

        @NotNull
        public final WorkSpec getWorkSpec$work_runtime_release() {
            return this.workSpec;
        }

        public final void setWorkSpec$work_runtime_release(@NotNull WorkSpec workSpec) {
            Intrinsics.checkNotNullParameter((Object)workSpec, (String)"<set-?>");
            this.workSpec = workSpec;
        }

        @NotNull
        public final Set<String> getTags$work_runtime_release() {
            return this.tags;
        }

        @NotNull
        public final B setId(@NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            String string = id.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
            this.workSpec = new WorkSpec(string, this.workSpec);
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final B setBackoffCriteria(@NotNull BackoffPolicy backoffPolicy, long backoffDelay, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)backoffPolicy), (String)"backoffPolicy");
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.backoffCriteriaSet = true;
            this.workSpec.backoffPolicy = backoffPolicy;
            this.workSpec.setBackoffDelayDuration(timeUnit.toMillis(backoffDelay));
            return this.getThisObject$work_runtime_release();
        }

        @RequiresApi(value=26)
        @NotNull
        public final B setBackoffCriteria(@NotNull BackoffPolicy backoffPolicy, @NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)((Object)backoffPolicy), (String)"backoffPolicy");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.backoffCriteriaSet = true;
            this.workSpec.backoffPolicy = backoffPolicy;
            this.workSpec.setBackoffDelayDuration(DurationApi26Impl.toMillisCompat(duration));
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final B setConstraints(@NotNull Constraints constraints) {
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            this.workSpec.constraints = constraints;
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final B setInputData(@NotNull Data inputData) {
            Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
            this.workSpec.input = inputData;
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final B addTag(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.tags.add(tag);
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final B keepResultsForAtLeast(long duration, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.workSpec.minimumRetentionDuration = timeUnit.toMillis(duration);
            return this.getThisObject$work_runtime_release();
        }

        @RequiresApi(value=26)
        @NotNull
        public final B keepResultsForAtLeast(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.workSpec.minimumRetentionDuration = DurationApi26Impl.toMillisCompat(duration);
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public B setInitialDelay(long duration, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.workSpec.initialDelay = timeUnit.toMillis(duration);
            if (!(Long.MAX_VALUE - System.currentTimeMillis() > this.workSpec.initialDelay)) {
                boolean bl = false;
                String string = "The given initial delay is too large and will cause an overflow!";
                throw new IllegalArgumentException(string.toString());
            }
            return this.getThisObject$work_runtime_release();
        }

        @RequiresApi(value=26)
        @NotNull
        public B setInitialDelay(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            this.workSpec.initialDelay = DurationApi26Impl.toMillisCompat(duration);
            if (!(Long.MAX_VALUE - System.currentTimeMillis() > this.workSpec.initialDelay)) {
                boolean bl = false;
                String string = "The given initial delay is too large and will cause an overflow!";
                throw new IllegalArgumentException(string.toString());
            }
            return this.getThisObject$work_runtime_release();
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NotNull
        public B setExpedited(@NotNull OutOfQuotaPolicy policy) {
            Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
            this.workSpec.expedited = true;
            this.workSpec.outOfQuotaPolicy = policy;
            return this.getThisObject$work_runtime_release();
        }

        @NotNull
        public final W build() {
            boolean hasUnsupportedConstraints;
            W returnValue = this.buildInternal$work_runtime_release();
            Constraints constraints = this.workSpec.constraints;
            boolean bl = hasUnsupportedConstraints = Build.VERSION.SDK_INT >= 24 && constraints.hasContentUriTriggers() || constraints.requiresBatteryNotLow() || constraints.requiresCharging() || Build.VERSION.SDK_INT >= 23 && constraints.requiresDeviceIdle();
            if (this.workSpec.expedited) {
                if (!(!hasUnsupportedConstraints)) {
                    boolean $i$a$-require-WorkRequest$Builder$build$32 = false;
                    String $i$a$-require-WorkRequest$Builder$build$32 = "Expedited jobs only support network and storage constraints";
                    throw new IllegalArgumentException($i$a$-require-WorkRequest$Builder$build$32.toString());
                }
                if (!(this.workSpec.initialDelay <= 0L)) {
                    boolean bl2 = false;
                    String string = "Expedited jobs cannot be delayed";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
            this.setId(uUID);
            return returnValue;
        }

        @NotNull
        public abstract W buildInternal$work_runtime_release();

        @NotNull
        public abstract B getThisObject$work_runtime_release();

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NotNull
        public final B setInitialState(@NotNull WorkInfo.State state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            this.workSpec.state = state;
            return this.getThisObject$work_runtime_release();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NotNull
        public final B setInitialRunAttemptCount(int runAttemptCount) {
            this.workSpec.runAttemptCount = runAttemptCount;
            return this.getThisObject$work_runtime_release();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NotNull
        public final B setLastEnqueueTime(long lastEnqueueTime, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.workSpec.lastEnqueueTime = timeUnit.toMillis(lastEnqueueTime);
            return this.getThisObject$work_runtime_release();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @VisibleForTesting
        @NotNull
        public final B setScheduleRequestedAt(long scheduleRequestedAt, @NotNull TimeUnit timeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            this.workSpec.scheduleRequestedAt = timeUnit.toMillis(scheduleRequestedAt);
            return this.getThisObject$work_runtime_release();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/work/WorkRequest$Companion;", "", "()V", "DEFAULT_BACKOFF_DELAY_MILLIS", "", "MAX_BACKOFF_MILLIS", "MIN_BACKOFF_MILLIS", "work-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

