/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.PrimaryKey;
import androidx.work.impl.model.WorkSpec;

@Entity(foreignKeys={@ForeignKey(entity=WorkSpec.class, parentColumns={"id"}, childColumns={"work_spec_id"}, onDelete=5, onUpdate=5)})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemIdInfo {
    @NonNull
    @PrimaryKey
    @ColumnInfo(name="work_spec_id")
    public final String workSpecId;
    @ColumnInfo(name="system_id")
    public final int systemId;

    public SystemIdInfo(@NonNull String workSpecId, int systemId) {
        this.workSpecId = workSpecId;
        this.systemId = systemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemIdInfo)) {
            return false;
        }
        SystemIdInfo that = (SystemIdInfo)o;
        if (this.systemId != that.systemId) {
            return false;
        }
        return this.workSpecId.equals(that.workSpecId);
    }

    public int hashCode() {
        int result = this.workSpecId.hashCode();
        result = 31 * result + this.systemId;
        return result;
    }
}

