/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.constraints.trackers.BroadcastReceiverConstraintTracker;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class StorageNotLowTracker
extends BroadcastReceiverConstraintTracker<Boolean> {
    private static final String TAG = Logger.tagWithPrefix("StorageNotLowTracker");

    public StorageNotLowTracker(@NonNull Context context, @NonNull TaskExecutor taskExecutor) {
        super(context, taskExecutor);
    }

    @Override
    public Boolean getInitialState() {
        Intent intent = this.mAppContext.registerReceiver(null, this.getIntentFilter());
        if (intent == null || intent.getAction() == null) {
            return true;
        }
        switch (intent.getAction()) {
            case "android.intent.action.DEVICE_STORAGE_OK": {
                return true;
            }
            case "android.intent.action.DEVICE_STORAGE_LOW": {
                return false;
            }
        }
        return null;
    }

    @Override
    public IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
        return intentFilter;
    }

    @Override
    public void onBroadcastReceive(Context context, @NonNull Intent intent) {
        if (intent.getAction() == null) {
            return;
        }
        Logger.get().debug(TAG, String.format("Received %s", intent.getAction()), new Throwable[0]);
        switch (intent.getAction()) {
            case "android.intent.action.DEVICE_STORAGE_OK": {
                this.setState(true);
                break;
            }
            case "android.intent.action.DEVICE_STORAGE_LOW": {
                this.setState(false);
            }
        }
    }
}

