/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class Logger {
    private static Logger sLogger;
    private static final String TAG_PREFIX = "WM-";
    private static final int MAX_TAG_LENGTH = 23;
    private static final int MAX_PREFIXED_TAG_LENGTH;

    public static synchronized void setLogger(Logger logger) {
        sLogger = logger;
    }

    public static String tagWithPrefix(@NonNull String tag) {
        int length = tag.length();
        StringBuilder withPrefix = new StringBuilder(23);
        withPrefix.append(TAG_PREFIX);
        if (length >= MAX_PREFIXED_TAG_LENGTH) {
            withPrefix.append(tag.substring(0, MAX_PREFIXED_TAG_LENGTH));
        } else {
            withPrefix.append(tag);
        }
        return withPrefix.toString();
    }

    public static synchronized Logger get() {
        if (sLogger == null) {
            sLogger = new LogcatLogger(3);
        }
        return sLogger;
    }

    public Logger(int loggingLevel) {
    }

    public abstract void verbose(String var1, String var2, Throwable ... var3);

    public abstract void debug(String var1, String var2, Throwable ... var3);

    public abstract void info(String var1, String var2, Throwable ... var3);

    public abstract void warning(String var1, String var2, Throwable ... var3);

    public abstract void error(String var1, String var2, Throwable ... var3);

    static {
        MAX_PREFIXED_TAG_LENGTH = 23 - TAG_PREFIX.length();
    }

    public static class LogcatLogger
    extends Logger {
        private int mLoggingLevel;

        public LogcatLogger(int loggingLevel) {
            super(loggingLevel);
            this.mLoggingLevel = loggingLevel;
        }

        @Override
        public void verbose(String tag, String message, Throwable ... throwables) {
            if (this.mLoggingLevel <= 2) {
                if (throwables != null && throwables.length >= 1) {
                    Log.v((String)tag, (String)message, (Throwable)throwables[0]);
                } else {
                    Log.v((String)tag, (String)message);
                }
            }
        }

        @Override
        public void debug(String tag, String message, Throwable ... throwables) {
            if (this.mLoggingLevel <= 3) {
                if (throwables != null && throwables.length >= 1) {
                    Log.d((String)tag, (String)message, (Throwable)throwables[0]);
                } else {
                    Log.d((String)tag, (String)message);
                }
            }
        }

        @Override
        public void info(String tag, String message, Throwable ... throwables) {
            if (this.mLoggingLevel <= 4) {
                if (throwables != null && throwables.length >= 1) {
                    Log.i((String)tag, (String)message, (Throwable)throwables[0]);
                } else {
                    Log.i((String)tag, (String)message);
                }
            }
        }

        @Override
        public void warning(String tag, String message, Throwable ... throwables) {
            if (this.mLoggingLevel <= 5) {
                if (throwables != null && throwables.length >= 1) {
                    Log.w((String)tag, (String)message, (Throwable)throwables[0]);
                } else {
                    Log.w((String)tag, (String)message);
                }
            }
        }

        @Override
        public void error(String tag, String message, Throwable ... throwables) {
            if (this.mLoggingLevel <= 6) {
                if (throwables != null && throwables.length >= 1) {
                    Log.e((String)tag, (String)message, (Throwable)throwables[0]);
                } else {
                    Log.e((String)tag, (String)message);
                }
            }
        }
    }
}

