/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.ForegroundInfo;
import androidx.work.ForegroundUpdater;
import androidx.work.WorkInfo;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.foreground.SystemForegroundDispatcher;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkForegroundUpdater
implements ForegroundUpdater {
    private final TaskExecutor mTaskExecutor;
    final ForegroundProcessor mForegroundProcessor;
    final WorkSpecDao mWorkSpecDao;

    public WorkForegroundUpdater(@NonNull WorkDatabase workDatabase, @NonNull ForegroundProcessor foregroundProcessor, @NonNull TaskExecutor taskExecutor) {
        this.mForegroundProcessor = foregroundProcessor;
        this.mTaskExecutor = taskExecutor;
        this.mWorkSpecDao = workDatabase.workSpecDao();
    }

    @Override
    @NonNull
    public ListenableFuture<Void> setForegroundAsync(final @NonNull Context context, final @NonNull UUID id, final @NonNull ForegroundInfo foregroundInfo) {
        final SettableFuture<Void> future = SettableFuture.create();
        this.mTaskExecutor.executeOnBackgroundThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!future.isCancelled()) {
                        String workSpecId = id.toString();
                        WorkInfo.State state = WorkForegroundUpdater.this.mWorkSpecDao.getState(workSpecId);
                        if (state == null || state.isFinished()) {
                            String message = "Calls to setForegroundAsync() must complete before a ListenableWorker signals completion of work by returning an instance of Result.";
                            throw new IllegalStateException(message);
                        }
                        WorkForegroundUpdater.this.mForegroundProcessor.startForeground(workSpecId, foregroundInfo);
                        Intent intent = SystemForegroundDispatcher.createNotifyIntent(context, workSpecId, foregroundInfo);
                        context.startService(intent);
                    }
                    future.set(null);
                }
                catch (Throwable throwable) {
                    future.setException(throwable);
                }
            }
        });
        return future;
    }
}

