/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.Logger;
import androidx.work.ProgressUpdater;
import androidx.work.WorkInfo;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.futures.SettableFuture;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkProgressUpdater
implements ProgressUpdater {
    static final String TAG = Logger.tagWithPrefix("WorkProgressUpdater");
    final WorkDatabase mWorkDatabase;
    final TaskExecutor mTaskExecutor;

    public WorkProgressUpdater(@NonNull WorkDatabase workDatabase, @NonNull TaskExecutor taskExecutor) {
        this.mWorkDatabase = workDatabase;
        this.mTaskExecutor = taskExecutor;
    }

    @Override
    @NonNull
    public ListenableFuture<Void> updateProgress(@NonNull Context context, final @NonNull UUID id, final @NonNull Data data) {
        final SettableFuture<Void> future = SettableFuture.create();
        this.mTaskExecutor.executeOnBackgroundThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String workSpecId = id.toString();
                Logger.get().debug(TAG, String.format("Updating progress for %s (%s)", id, data), new Throwable[0]);
                WorkProgressUpdater.this.mWorkDatabase.beginTransaction();
                try {
                    WorkSpecDao workSpecDao = WorkProgressUpdater.this.mWorkDatabase.workSpecDao();
                    WorkSpec workSpec = workSpecDao.getWorkSpec(workSpecId);
                    if (workSpec != null) {
                        WorkInfo.State state = workSpec.state;
                        if (state == WorkInfo.State.RUNNING) {
                            WorkProgress progress = new WorkProgress(workSpecId, data);
                            WorkProgressUpdater.this.mWorkDatabase.workProgressDao().insert(progress);
                        } else {
                            Logger.get().warning(TAG, String.format("Ignoring setProgressAsync(...). WorkSpec (%s) is not in a RUNNING state.", workSpecId), new Throwable[0]);
                        }
                    } else {
                        String message = "Calls to setProgressAsync() must complete before a ListenableWorker signals completion of work by returning an instance of Result.";
                        throw new IllegalStateException(message);
                    }
                    future.set(null);
                    WorkProgressUpdater.this.mWorkDatabase.setTransactionSuccessful();
                }
                catch (Throwable throwable) {
                    Logger.get().error(TAG, "Error updating Worker progress", throwable);
                    future.setException(throwable);
                }
                finally {
                    WorkProgressUpdater.this.mWorkDatabase.endTransaction();
                }
            }
        });
        return future;
    }
}

