/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.work.Constraints;
import androidx.work.Logger;
import androidx.work.NetworkType;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.background.systemalarm.ConstraintProxyUpdateReceiver;
import androidx.work.impl.model.WorkSpec;
import java.util.List;

abstract class ConstraintProxy
extends BroadcastReceiver {
    private static final String TAG = Logger.tagWithPrefix("ConstraintProxy");

    ConstraintProxy() {
    }

    public void onReceive(Context context, Intent intent) {
        Logger.get().debug(TAG, String.format("onReceive : %s", intent), new Throwable[0]);
        Intent constraintChangedIntent = CommandHandler.createConstraintsChangedIntent(context);
        context.startService(constraintChangedIntent);
    }

    static void updateAll(Context context, List<WorkSpec> workSpecs) {
        boolean batteryNotLowProxyEnabled = false;
        boolean batteryChargingProxyEnabled = false;
        boolean storageNotLowProxyEnabled = false;
        boolean networkStateProxyEnabled = false;
        for (WorkSpec workSpec : workSpecs) {
            Constraints constraints = workSpec.constraints;
            if (!(batteryNotLowProxyEnabled |= constraints.requiresBatteryNotLow()) || !(batteryChargingProxyEnabled |= constraints.requiresCharging()) || !(storageNotLowProxyEnabled |= constraints.requiresStorageNotLow()) || !(networkStateProxyEnabled |= constraints.getRequiredNetworkType() != NetworkType.NOT_REQUIRED)) continue;
            break;
        }
        Intent updateProxyIntent = ConstraintProxyUpdateReceiver.newConstraintProxyUpdateIntent(context, batteryNotLowProxyEnabled, batteryChargingProxyEnabled, storageNotLowProxyEnabled, networkStateProxyEnabled);
        context.sendBroadcast(updateProxyIntent);
    }

    public static class NetworkStateProxy
    extends ConstraintProxy {
    }

    public static class StorageNotLowProxy
    extends ConstraintProxy {
    }

    public static class BatteryChargingProxy
    extends ConstraintProxy {
    }

    public static class BatteryNotLowProxy
    extends ConstraintProxy {
    }
}

