/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/work/lint/BadConfigurationProviderIssueDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "correct", "", "hasApplicableTypes", "location", "Lcom/android/tools/lint/detector/api/Location;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableSuperClasses", "", "", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "work-runtime-lint"})
public final class BadConfigurationProviderIssueDetector
extends Detector
implements SourceCodeScanner {
    private boolean hasApplicableTypes;
    private boolean correct;
    private Location location;
    @NotNull
    private static final Issue ISSUE;
    public static final Companion Companion;

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object[])new String[]{"android.app.Application", "androidx.work.Configuration.Provider"});
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (this.correct) {
            return;
        }
        String name = declaration.getQualifiedName();
        if (Intrinsics.areEqual((Object)name, (Object)"androidx.work.Configuration.Provider") || Intrinsics.areEqual((Object)name, (Object)"android.app.Application")) {
            return;
        }
        boolean isApplication = context.getEvaluator().inheritsFrom(declaration.getJavaPsi(), "android.app.Application", true);
        boolean isProvider = context.getEvaluator().inheritsFrom(declaration.getJavaPsi(), "androidx.work.Configuration.Provider", true);
        if (isApplication) {
            this.location = Location.Companion.create(context.file);
        }
        if (isProvider) {
            this.hasApplicableTypes = true;
        }
        if (isApplication && isProvider) {
            this.correct = true;
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (this.hasApplicableTypes && !this.correct) {
            Location location = this.location;
            if (location == null) {
                location = Location.Companion.create(context.file);
            }
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"Expected Application subtype to implement Configuration.Provider", null, (int)8, null);
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Implementation implementation = new Implementation(BadConfigurationProviderIssueDetector.class, Scope.JAVA_FILE_SCOPE);
        boolean bl = false;
        Severity severity = Severity.FATAL;
        int n = 0;
        Category category = Category.CORRECTNESS;
        String string = null;
        Boolean bl2 = true;
        ISSUE = Issue.Companion.create$default((Issue.Companion)Issue.Companion, (String)"BadConfigurationProvider", (String)"Invalid WorkManager Configuration Provider", (String)"\n                An `android.app.Application` must implement `androidx.work.Configuration.Provider`\n                for on-demand initialization.\n            ", (Implementation)implementation, string, (Category)category, (int)n, (Severity)severity, (boolean)bl, (Boolean)bl2, enumSet, collection, (int)3408, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/work/lint/BadConfigurationProviderIssueDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "work-runtime-lint"})
    public static final class Companion {
        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

