/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.foreground;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.WorkConstraintsCallback;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.foreground.SystemForegroundService;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemForegroundDispatcher
implements WorkConstraintsCallback,
ExecutionListener {
    static final String TAG = Logger.tagWithPrefix("SystemFgDispatcher");
    private static final String KEY_NOTIFICATION = "KEY_NOTIFICATION";
    private static final String KEY_NOTIFICATION_ID = "KEY_NOTIFICATION_ID";
    private static final String KEY_FOREGROUND_SERVICE_TYPE = "KEY_FOREGROUND_SERVICE_TYPE";
    private static final String KEY_NOTIFICATION_TAG = "KEY_NOTIFICATION_TAG";
    private static final String KEY_WORKSPEC_ID = "KEY_WORKSPEC_ID";
    private static final String ACTION_START_FOREGROUND = "ACTION_START_FOREGROUND";
    private static final String ACTION_NOTIFY = "ACTION_NOTIFY";
    private static final String ACTION_STOP_FOREGROUND = "ACTION_STOP_FOREGROUND";
    private static final String ACTION_CANCEL_WORK = "ACTION_CANCEL_WORK";
    @VisibleForTesting
    public static final int NOTIFICATION_ID = 42;
    private Context mContext;
    private WorkManagerImpl mWorkManagerImpl;
    private final TaskExecutor mTaskExecutor;
    final Object mLock;
    final Map<String, WorkSpec> mWorkSpecById;
    final Set<WorkSpec> mTrackedWorkSpecs;
    final WorkConstraintsTracker mConstraintsTracker;
    @Nullable
    private Callback mCallback;

    SystemForegroundDispatcher(@NonNull Context context) {
        this.mContext = context;
        this.mLock = new Object();
        this.mWorkManagerImpl = WorkManagerImpl.getInstance(this.mContext);
        this.mTaskExecutor = this.mWorkManagerImpl.getWorkTaskExecutor();
        this.mTrackedWorkSpecs = new HashSet<WorkSpec>();
        this.mWorkSpecById = new HashMap<String, WorkSpec>();
        this.mConstraintsTracker = new WorkConstraintsTracker(this.mContext, this.mTaskExecutor, this);
        this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
    }

    @VisibleForTesting
    SystemForegroundDispatcher(@NonNull Context context, @NonNull WorkManagerImpl workManagerImpl, @NonNull WorkConstraintsTracker tracker) {
        this.mContext = context;
        this.mLock = new Object();
        this.mWorkManagerImpl = workManagerImpl;
        this.mTaskExecutor = this.mWorkManagerImpl.getWorkTaskExecutor();
        this.mTrackedWorkSpecs = new HashSet<WorkSpec>();
        this.mWorkSpecById = new HashMap<String, WorkSpec>();
        this.mConstraintsTracker = tracker;
        this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void onExecuted(@NonNull String workSpecId, boolean needsReschedule) {
        boolean removed = false;
        Object object = this.mLock;
        synchronized (object) {
            WorkSpec workSpec = this.mWorkSpecById.remove(workSpecId);
            if (workSpec != null) {
                removed = this.mTrackedWorkSpecs.remove(workSpec);
            }
        }
        if (removed) {
            this.mConstraintsTracker.replace(this.mTrackedWorkSpecs);
        }
    }

    @MainThread
    void setCallback(@NonNull Callback callback) {
        if (this.mCallback != null) {
            Logger.get().error(TAG, "A callback already exists.", new Throwable[0]);
            return;
        }
        this.mCallback = callback;
    }

    WorkManagerImpl getWorkManager() {
        return this.mWorkManagerImpl;
    }

    void onStartCommand(@NonNull Intent intent) {
        String action = intent.getAction();
        if (ACTION_START_FOREGROUND.equals(action)) {
            this.handleStartForeground(intent);
        } else if (ACTION_STOP_FOREGROUND.equals(action)) {
            this.handleStop(intent);
        } else if (ACTION_NOTIFY.equals(action)) {
            this.handleNotify(intent);
        } else if (ACTION_CANCEL_WORK.equals(action)) {
            this.handleCancelWork(intent);
        }
    }

    @MainThread
    void onDestroy() {
        this.mCallback = null;
        this.mConstraintsTracker.reset();
        this.mWorkManagerImpl.getProcessor().removeExecutionListener(this);
    }

    @MainThread
    private void handleStartForeground(@NonNull Intent intent) {
        Logger.get().info(TAG, String.format("Started foreground service %s", intent), new Throwable[0]);
        final String workSpecId = intent.getStringExtra(KEY_WORKSPEC_ID);
        final WorkDatabase database = this.mWorkManagerImpl.getWorkDatabase();
        this.mTaskExecutor.executeOnBackgroundThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WorkSpec workSpec = database.workSpecDao().getWorkSpec(workSpecId);
                if (workSpec != null && workSpec.hasConstraints()) {
                    Object object = SystemForegroundDispatcher.this.mLock;
                    synchronized (object) {
                        SystemForegroundDispatcher.this.mWorkSpecById.put(workSpecId, workSpec);
                        SystemForegroundDispatcher.this.mTrackedWorkSpecs.add(workSpec);
                    }
                    SystemForegroundDispatcher.this.mConstraintsTracker.replace(SystemForegroundDispatcher.this.mTrackedWorkSpecs);
                }
            }
        });
    }

    @MainThread
    private void handleNotify(@NonNull Intent intent) {
        int notificationId = intent.getIntExtra(KEY_NOTIFICATION_ID, 0);
        int notificationType = intent.getIntExtra(KEY_FOREGROUND_SERVICE_TYPE, 0);
        String notificationTag = intent.getStringExtra(KEY_NOTIFICATION_TAG);
        Notification notification = (Notification)intent.getParcelableExtra(KEY_NOTIFICATION);
        if (notification != null && this.mCallback != null) {
            this.mCallback.notify(notificationId, notificationType, notificationTag, notification);
        }
    }

    @MainThread
    private void handleStop(@NonNull Intent intent) {
        Logger.get().info(TAG, String.format("Stopping foreground service %s", intent), new Throwable[0]);
        if (this.mCallback != null) {
            this.mCallback.stop();
        }
    }

    @MainThread
    private void handleCancelWork(@NonNull Intent intent) {
        Logger.get().info(TAG, String.format("Stopping foreground work for %s", intent), new Throwable[0]);
        String workSpecId = intent.getStringExtra(KEY_WORKSPEC_ID);
        if (workSpecId != null && !TextUtils.isEmpty((CharSequence)workSpecId)) {
            this.mWorkManagerImpl.cancelWorkById(UUID.fromString(workSpecId));
        }
    }

    @Override
    public void onAllConstraintsMet(@NonNull List<String> workSpecIds) {
    }

    @Override
    public void onAllConstraintsNotMet(@NonNull List<String> workSpecIds) {
        if (!workSpecIds.isEmpty()) {
            for (String workSpecId : workSpecIds) {
                Logger.get().debug(TAG, String.format("Constraints unmet for WorkSpec %s", workSpecId), new Throwable[0]);
                this.mWorkManagerImpl.stopForegroundWork(workSpecId);
            }
        }
    }

    @NonNull
    public static Intent createStartForegroundIntent(@NonNull Context context, @NonNull String workSpecId) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_START_FOREGROUND);
        intent.putExtra(KEY_WORKSPEC_ID, workSpecId);
        return intent;
    }

    @NonNull
    public static Intent createCancelWorkIntent(@NonNull Context context, @NonNull String workSpecId) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_CANCEL_WORK);
        intent.setData(Uri.parse((String)String.format("workspec://%s", workSpecId)));
        intent.putExtra(KEY_WORKSPEC_ID, workSpecId);
        return intent;
    }

    @NonNull
    public static Intent createNotifyIntent(@NonNull Context context, @NonNull String workSpecId, @NonNull ForegroundInfo info) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_NOTIFY);
        intent.putExtra(KEY_NOTIFICATION_ID, 42);
        intent.putExtra(KEY_FOREGROUND_SERVICE_TYPE, info.getForegroundServiceType());
        intent.putExtra(KEY_NOTIFICATION, (Parcelable)info.getNotification());
        intent.putExtra(KEY_NOTIFICATION_TAG, workSpecId);
        return intent;
    }

    @NonNull
    public static Intent createStopForegroundIntent(@NonNull Context context) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_STOP_FOREGROUND);
        return intent;
    }

    static interface Callback {
        public void notify(int var1, int var2, @Nullable String var3, @NonNull Notification var4);

        public void stop();
    }
}

