/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.app.Notification;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public final class ForegroundInfo {
    private final int mForegroundServiceType;
    private final Notification mNotification;

    public ForegroundInfo(@NonNull Notification notification) {
        this(notification, 0);
    }

    public ForegroundInfo(@NonNull Notification notification, int foregroundServiceType) {
        this.mNotification = notification;
        this.mForegroundServiceType = foregroundServiceType;
    }

    public int getForegroundServiceType() {
        return this.mForegroundServiceType;
    }

    @NonNull
    public Notification getNotification() {
        return this.mNotification;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ForegroundInfo that = (ForegroundInfo)other;
        if (this.mForegroundServiceType != that.mForegroundServiceType) {
            return false;
        }
        return this.mNotification != null ? this.mNotification.equals(that.mNotification) : that.mNotification == null;
    }

    public int hashCode() {
        int result = this.mForegroundServiceType;
        result = 31 * result + (this.mNotification != null ? this.mNotification.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder("ForegroundInfo{");
        sb.append("mForegroundServiceType=").append(this.mForegroundServiceType);
        sb.append(", mNotification=").append(this.mNotification);
        sb.append('}');
        return sb.toString();
    }
}

