/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints.trackers;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.work.Logger;
import androidx.work.impl.constraints.ConstraintListener;
import androidx.work.impl.constraints.trackers.ConstraintTrackerKt;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\r\u0010\u001a\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u001b\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fJ\b\u0010\u001c\u001a\u00020\u0018H&J\b\u0010\u001d\u001a\u00020\u0018H&R\u0014\u0010\b\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00028\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/work/impl/constraints/trackers/ConstraintTracker;", "T", "", "context", "Landroid/content/Context;", "taskExecutor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "(Landroid/content/Context;Landroidx/work/impl/utils/taskexecutor/TaskExecutor;)V", "appContext", "getAppContext", "()Landroid/content/Context;", "currentState", "Ljava/lang/Object;", "listeners", "Ljava/util/LinkedHashSet;", "Landroidx/work/impl/constraints/ConstraintListener;", "lock", "newState", "state", "getState", "()Ljava/lang/Object;", "setState", "(Ljava/lang/Object;)V", "addListener", "", "listener", "readSystemState", "removeListener", "startTracking", "stopTracking", "work-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nConstraintTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstraintTracker.kt\nandroidx/work/impl/constraints/trackers/ConstraintTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 ConstraintTracker.kt\nandroidx/work/impl/constraints/trackers/ConstraintTracker\n*L\n90#1:114,2\n*E\n"})
public abstract class ConstraintTracker<T> {
    @NotNull
    private final TaskExecutor taskExecutor;
    @NotNull
    private final Context appContext;
    @NotNull
    private final Object lock;
    @NotNull
    private final LinkedHashSet<ConstraintListener<T>> listeners;
    @Nullable
    private T currentState;

    protected ConstraintTracker(@NotNull Context context, @NotNull TaskExecutor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.taskExecutor = taskExecutor;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.appContext = context2;
        this.lock = new Object();
        this.listeners = new LinkedHashSet();
    }

    @NotNull
    protected final Context getAppContext() {
        return this.appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(@NotNull ConstraintListener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.listeners.add(listener2)) {
                if (this.listeners.size() == 1) {
                    this.currentState = this.readSystemState();
                    Logger.get().debug(ConstraintTrackerKt.access$getTAG$p(), this.getClass().getSimpleName() + ": initial state = " + this.currentState);
                    this.startTracking();
                }
                listener2.onConstraintChanged(this.currentState);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull ConstraintListener<T> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.listeners.remove(listener2) && this.listeners.isEmpty()) {
                this.stopTracking();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final T getState() {
        T t = this.currentState;
        if (t == null) {
            t = this.readSystemState();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setState(T newState) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.currentState != null && Intrinsics.areEqual(this.currentState, newState)) {
                return;
            }
            this.currentState = newState;
            List listenersList = CollectionsKt.toList((Iterable)this.listeners);
            this.taskExecutor.getMainThreadExecutor().execute(() -> ConstraintTracker._set_state_$lambda$4$lambda$3(listenersList, this));
            Unit unit = Unit.INSTANCE;
        }
    }

    public abstract T readSystemState();

    public abstract void startTracking();

    public abstract void stopTracking();

    private static final void _set_state_$lambda$4$lambda$3(List $listenersList, ConstraintTracker this$0) {
        Iterable $this$forEach$iv = $listenersList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConstraintListener listener2 = (ConstraintListener)element$iv;
            boolean bl = false;
            listener2.onConstraintChanged(this$0.currentState);
        }
    }
}

