/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.app.Notification;
import androidx.annotation.NonNull;

public final class ForegroundInfo {
    private final int mNotificationId;
    private final int mForegroundServiceType;
    private final Notification mNotification;

    public ForegroundInfo(int notificationId, @NonNull Notification notification) {
        this(notificationId, notification, 0);
    }

    public ForegroundInfo(int notificationId, @NonNull Notification notification, int foregroundServiceType) {
        this.mNotificationId = notificationId;
        this.mNotification = notification;
        this.mForegroundServiceType = foregroundServiceType;
    }

    public int getNotificationId() {
        return this.mNotificationId;
    }

    public int getForegroundServiceType() {
        return this.mForegroundServiceType;
    }

    @NonNull
    public Notification getNotification() {
        return this.mNotification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForegroundInfo that = (ForegroundInfo)o;
        if (this.mNotificationId != that.mNotificationId) {
            return false;
        }
        if (this.mForegroundServiceType != that.mForegroundServiceType) {
            return false;
        }
        return this.mNotification.equals(that.mNotification);
    }

    public int hashCode() {
        int result2 = this.mNotificationId;
        result2 = 31 * result2 + this.mForegroundServiceType;
        result2 = 31 * result2 + this.mNotification.hashCode();
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ForegroundInfo{");
        sb.append("mNotificationId=").append(this.mNotificationId);
        sb.append(", mForegroundServiceType=").append(this.mForegroundServiceType);
        sb.append(", mNotification=").append(this.mNotification);
        sb.append('}');
        return sb.toString();
    }
}

