/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.ListenableFutureKt;
import androidx.work.Logger;
import androidx.work.ProgressUpdater;
import androidx.work.WorkInfo;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.WorkProgress;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WorkProgressUpdater
implements ProgressUpdater {
    static final String TAG = Logger.tagWithPrefix("WorkProgressUpdater");
    final WorkDatabase mWorkDatabase;
    final TaskExecutor mTaskExecutor;

    public WorkProgressUpdater(@NonNull WorkDatabase workDatabase, @NonNull TaskExecutor taskExecutor) {
        this.mWorkDatabase = workDatabase;
        this.mTaskExecutor = taskExecutor;
    }

    @Override
    @NonNull
    public ListenableFuture<Void> updateProgress(@NonNull Context context, @NonNull UUID id, @NonNull Data data) {
        return ListenableFutureKt.executeAsync(this.mTaskExecutor.getSerialTaskExecutor(), "updateProgress", () -> {
            String workSpecId = id.toString();
            Logger.get().debug(TAG, "Updating progress for " + id + " (" + data + ")");
            this.mWorkDatabase.beginTransaction();
            try {
                WorkSpecDao workSpecDao = this.mWorkDatabase.workSpecDao();
                WorkSpec workSpec = workSpecDao.getWorkSpec(workSpecId);
                if (workSpec != null) {
                    WorkInfo.State state = workSpec.state;
                    if (state == WorkInfo.State.RUNNING) {
                        WorkProgress progress = new WorkProgress(workSpecId, data);
                        this.mWorkDatabase.workProgressDao().insert(progress);
                    } else {
                        Logger.get().warning(TAG, "Ignoring setProgressAsync(...). WorkSpec (" + workSpecId + ") is not in a RUNNING state.");
                    }
                } else {
                    String message = "Calls to setProgressAsync() must complete before a ListenableWorker signals completion of work by returning an instance of Result.";
                    throw new IllegalStateException(message);
                }
                this.mWorkDatabase.setTransactionSuccessful();
            }
            catch (Throwable throwable) {
                Logger.get().error(TAG, "Error updating Worker progress", throwable);
                throw throwable;
            }
            finally {
                this.mWorkDatabase.endTransaction();
            }
            return null;
        });
    }
}

