/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerFactoryKt;
import androidx.work.WorkerParameters;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Landroidx/work/WorkerFactory;", "", "()V", "createWorker", "Landroidx/work/ListenableWorker;", "appContext", "Landroid/content/Context;", "workerClassName", "", "workerParameters", "Landroidx/work/WorkerParameters;", "createWorkerWithDefaultFallback", "work-runtime_release"})
public abstract class WorkerFactory {
    @Nullable
    public abstract ListenableWorker createWorker(@NotNull Context var1, @NotNull String var2, @NotNull WorkerParameters var3);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final ListenableWorker createWorkerWithDefaultFallback(@NotNull Context appContext, @NotNull String workerClassName, @NotNull WorkerParameters workerParameters) {
        ListenableWorker worker;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        ListenableWorker listenableWorker = this.createWorker(appContext, workerClassName, workerParameters);
        if (listenableWorker == null) {
            listenableWorker = WorkerFactory.createWorkerWithDefaultFallback$fallbackToReflection(appContext, workerClassName, workerParameters);
        }
        if ((worker = listenableWorker).isUsed()) {
            String message = "WorkerFactory (" + this.getClass().getName() + ") returned an instance of a ListenableWorker (" + workerClassName + ") which has already been invoked. createWorker() must always return a new instance of a ListenableWorker.";
            throw new IllegalStateException(message);
        }
        return worker;
    }

    private static final Class<? extends ListenableWorker> createWorkerWithDefaultFallback$getWorkerClass(String workerClassName) {
        Class<ListenableWorker> clazz;
        try {
            Class<ListenableWorker> clazz2 = Class.forName(workerClassName).asSubclass(ListenableWorker.class);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n                Class.\u2026class.java)\n            }");
            clazz = clazz2;
        }
        catch (Throwable throwable) {
            Logger.get().error(WorkerFactoryKt.access$getTAG$p(), "Invalid class: " + workerClassName, throwable);
            throw throwable;
        }
        return clazz;
    }

    private static final ListenableWorker createWorkerWithDefaultFallback$fallbackToReflection(Context $appContext, String workerClassName, WorkerParameters workerParameters) {
        ListenableWorker listenableWorker;
        Class<? extends ListenableWorker> clazz = WorkerFactory.createWorkerWithDefaultFallback$getWorkerClass(workerClassName);
        try {
            Object[] objectArray = new Class[]{Context.class, WorkerParameters.class};
            Constructor<? extends ListenableWorker> constructor = clazz.getDeclaredConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{$appContext, workerParameters};
            ListenableWorker listenableWorker2 = constructor.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)listenableWorker2, (String)"{\n                val co\u2026Parameters)\n            }");
            listenableWorker = listenableWorker2;
        }
        catch (Throwable e) {
            Logger.get().error(WorkerFactoryKt.access$getTAG$p(), "Could not instantiate " + workerClassName, e);
            throw e;
        }
        return listenableWorker;
    }
}

