/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.work.impl.model.Dependency;
import androidx.work.impl.model.DependencyDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DependencyDao_Impl
implements DependencyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Dependency> __insertionAdapterOfDependency;

    public DependencyDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDependency = new EntityInsertionAdapter<Dependency>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR IGNORE INTO `Dependency` (`work_spec_id`,`prerequisite_id`) VALUES (?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Dependency entity) {
                statement.bindString(1, entity.getWorkSpecId());
                statement.bindString(2, entity.getPrerequisiteId());
            }
        };
    }

    @Override
    public void insertDependency(Dependency dependency) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfDependency.insert((Object)dependency);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCompletedAllPrerequisites(String id) {
        String _sql = "SELECT COUNT(*)=0 FROM dependency WHERE work_spec_id=? AND prerequisite_id IN (SELECT id FROM workspec WHERE state!=2)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*)=0 FROM dependency WHERE work_spec_id=? AND prerequisite_id IN (SELECT id FROM workspec WHERE state!=2)", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getPrerequisites(String id) {
        String _sql = "SELECT prerequisite_id FROM dependency WHERE work_spec_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT prerequisite_id FROM dependency WHERE work_spec_id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDependentWorkIds(String id) {
        String _sql = "SELECT work_spec_id FROM dependency WHERE prerequisite_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT work_spec_id FROM dependency WHERE prerequisite_id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDependents(String id) {
        String _sql = "SELECT COUNT(*)>0 FROM dependency WHERE prerequisite_id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(*)>0 FROM dependency WHERE prerequisite_id=?", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, id);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

