/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.foreground;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.constraints.ConstraintsState;
import androidx.work.impl.constraints.OnConstraintsStateChangedListener;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerKt;
import androidx.work.impl.foreground.SystemForegroundService;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlinx.coroutines.Job;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemForegroundDispatcher
implements OnConstraintsStateChangedListener,
ExecutionListener {
    static final String TAG = Logger.tagWithPrefix("SystemFgDispatcher");
    private static final String KEY_NOTIFICATION = "KEY_NOTIFICATION";
    private static final String KEY_NOTIFICATION_ID = "KEY_NOTIFICATION_ID";
    private static final String KEY_FOREGROUND_SERVICE_TYPE = "KEY_FOREGROUND_SERVICE_TYPE";
    private static final String KEY_WORKSPEC_ID = "KEY_WORKSPEC_ID";
    private static final String KEY_GENERATION = "KEY_GENERATION";
    private static final String ACTION_START_FOREGROUND = "ACTION_START_FOREGROUND";
    private static final String ACTION_NOTIFY = "ACTION_NOTIFY";
    private static final String ACTION_CANCEL_WORK = "ACTION_CANCEL_WORK";
    private static final String ACTION_STOP_FOREGROUND = "ACTION_STOP_FOREGROUND";
    private Context mContext;
    private WorkManagerImpl mWorkManagerImpl;
    private final TaskExecutor mTaskExecutor;
    final Object mLock;
    WorkGenerationalId mCurrentForegroundId;
    final Map<WorkGenerationalId, ForegroundInfo> mForegroundInfoById;
    final Map<WorkGenerationalId, WorkSpec> mWorkSpecById;
    final Map<WorkGenerationalId, Job> mTrackedWorkSpecs;
    final WorkConstraintsTracker mConstraintsTracker;
    @Nullable
    private Callback mCallback;

    SystemForegroundDispatcher(@NonNull Context context) {
        this.mContext = context;
        this.mLock = new Object();
        this.mWorkManagerImpl = WorkManagerImpl.getInstance(this.mContext);
        this.mTaskExecutor = this.mWorkManagerImpl.getWorkTaskExecutor();
        this.mCurrentForegroundId = null;
        this.mForegroundInfoById = new LinkedHashMap<WorkGenerationalId, ForegroundInfo>();
        this.mTrackedWorkSpecs = new HashMap<WorkGenerationalId, Job>();
        this.mWorkSpecById = new HashMap<WorkGenerationalId, WorkSpec>();
        this.mConstraintsTracker = new WorkConstraintsTracker(this.mWorkManagerImpl.getTrackers());
        this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
    }

    @VisibleForTesting
    SystemForegroundDispatcher(@NonNull Context context, @NonNull WorkManagerImpl workManagerImpl, @NonNull WorkConstraintsTracker tracker) {
        this.mContext = context;
        this.mLock = new Object();
        this.mWorkManagerImpl = workManagerImpl;
        this.mTaskExecutor = this.mWorkManagerImpl.getWorkTaskExecutor();
        this.mCurrentForegroundId = null;
        this.mForegroundInfoById = new LinkedHashMap<WorkGenerationalId, ForegroundInfo>();
        this.mTrackedWorkSpecs = new HashMap<WorkGenerationalId, Job>();
        this.mWorkSpecById = new HashMap<WorkGenerationalId, WorkSpec>();
        this.mConstraintsTracker = tracker;
        this.mWorkManagerImpl.getProcessor().addExecutionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MainThread
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        Job removed = null;
        Object object = this.mLock;
        synchronized (object) {
            WorkSpec workSpec = this.mWorkSpecById.remove(id);
            if (workSpec != null) {
                removed = this.mTrackedWorkSpecs.remove(id);
            }
            if (removed != null) {
                removed.cancel(null);
            }
        }
        ForegroundInfo removedInfo = this.mForegroundInfoById.remove(id);
        if (id.equals(this.mCurrentForegroundId)) {
            if (this.mForegroundInfoById.size() > 0) {
                Iterator<Map.Entry<WorkGenerationalId, ForegroundInfo>> iterator = this.mForegroundInfoById.entrySet().iterator();
                Map.Entry<WorkGenerationalId, ForegroundInfo> entry = iterator.next();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                }
                this.mCurrentForegroundId = entry.getKey();
                if (this.mCallback != null) {
                    ForegroundInfo info = entry.getValue();
                    this.mCallback.startForeground(info.getNotificationId(), info.getForegroundServiceType(), info.getNotification());
                    this.mCallback.cancelNotification(info.getNotificationId());
                }
            } else {
                this.mCurrentForegroundId = null;
            }
        }
        Callback callback = this.mCallback;
        if (removedInfo != null && callback != null) {
            Logger.get().debug(TAG, "Removing Notification (id: " + removedInfo.getNotificationId() + ", workSpecId: " + id + ", notificationType: " + removedInfo.getForegroundServiceType());
            callback.cancelNotification(removedInfo.getNotificationId());
        }
    }

    @MainThread
    void setCallback(@NonNull Callback callback) {
        if (this.mCallback != null) {
            Logger.get().error(TAG, "A callback already exists.");
            return;
        }
        this.mCallback = callback;
    }

    @MainThread
    void onStartCommand(@NonNull Intent intent) {
        String action = intent.getAction();
        if (ACTION_START_FOREGROUND.equals(action)) {
            this.handleStartForeground(intent);
            this.handleNotify(intent);
        } else if (ACTION_NOTIFY.equals(action)) {
            this.handleNotify(intent);
        } else if (ACTION_CANCEL_WORK.equals(action)) {
            this.handleCancelWork(intent);
        } else if (ACTION_STOP_FOREGROUND.equals(action)) {
            this.handleStop(intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    void onDestroy() {
        this.mCallback = null;
        Object object = this.mLock;
        synchronized (object) {
            for (Job job2 : this.mTrackedWorkSpecs.values()) {
                job2.cancel(null);
            }
        }
        this.mWorkManagerImpl.getProcessor().removeExecutionListener(this);
    }

    @MainThread
    void onTimeout(int startId, int fgsType) {
        Logger.get().info(TAG, "Foreground service timed out, FGS type: " + fgsType);
        for (Map.Entry<WorkGenerationalId, ForegroundInfo> entry : this.mForegroundInfoById.entrySet()) {
            ForegroundInfo info = entry.getValue();
            if (info.getForegroundServiceType() != fgsType) continue;
            WorkGenerationalId id = entry.getKey();
            this.mWorkManagerImpl.stopForegroundWork(id, -128);
        }
        if (this.mCallback != null) {
            this.mCallback.stop();
        }
    }

    @MainThread
    private void handleStartForeground(@NonNull Intent intent) {
        Logger.get().info(TAG, "Started foreground service " + intent);
        final String workSpecId = intent.getStringExtra(KEY_WORKSPEC_ID);
        this.mTaskExecutor.executeOnTaskThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WorkSpec workSpec = SystemForegroundDispatcher.this.mWorkManagerImpl.getProcessor().getRunningWorkSpec(workSpecId);
                if (workSpec != null && workSpec.hasConstraints()) {
                    Object object = SystemForegroundDispatcher.this.mLock;
                    synchronized (object) {
                        SystemForegroundDispatcher.this.mWorkSpecById.put(WorkSpecKt.generationalId(workSpec), workSpec);
                        Job job2 = WorkConstraintsTrackerKt.listen(SystemForegroundDispatcher.this.mConstraintsTracker, workSpec, SystemForegroundDispatcher.this.mTaskExecutor.getTaskCoroutineDispatcher(), SystemForegroundDispatcher.this);
                        SystemForegroundDispatcher.this.mTrackedWorkSpecs.put(WorkSpecKt.generationalId(workSpec), job2);
                    }
                }
            }
        });
    }

    @MainThread
    private void handleNotify(@NonNull Intent intent) {
        ForegroundInfo resultInfo;
        if (this.mCallback == null) {
            throw new IllegalStateException("handleNotify was called on the destroyed dispatcher");
        }
        int notificationId = intent.getIntExtra(KEY_NOTIFICATION_ID, 0);
        int notificationType = intent.getIntExtra(KEY_FOREGROUND_SERVICE_TYPE, 0);
        String workSpecId = intent.getStringExtra(KEY_WORKSPEC_ID);
        int generation = intent.getIntExtra(KEY_GENERATION, 0);
        WorkGenerationalId workId = new WorkGenerationalId(workSpecId, generation);
        Notification notification = (Notification)intent.getParcelableExtra(KEY_NOTIFICATION);
        Logger.get().debug(TAG, "Notifying with (id:" + notificationId + ", workSpecId: " + workSpecId + ", notificationType :" + notificationType + ")");
        if (notification == null) {
            throw new IllegalArgumentException("Notification passed in the intent was null.");
        }
        ForegroundInfo info = new ForegroundInfo(notificationId, notification, notificationType);
        this.mForegroundInfoById.put(workId, info);
        ForegroundInfo currentInfo = this.mForegroundInfoById.get(this.mCurrentForegroundId);
        if (currentInfo == null) {
            this.mCurrentForegroundId = workId;
            resultInfo = info;
        } else {
            this.mCallback.notify(notificationId, notification);
            if (Build.VERSION.SDK_INT >= 29) {
                int foregroundServiceType = 0;
                for (Map.Entry<WorkGenerationalId, ForegroundInfo> entry : this.mForegroundInfoById.entrySet()) {
                    ForegroundInfo foregroundInfo = entry.getValue();
                    foregroundServiceType |= foregroundInfo.getForegroundServiceType();
                }
                resultInfo = new ForegroundInfo(currentInfo.getNotificationId(), currentInfo.getNotification(), foregroundServiceType);
            } else {
                resultInfo = currentInfo;
            }
        }
        this.mCallback.startForeground(resultInfo.getNotificationId(), resultInfo.getForegroundServiceType(), resultInfo.getNotification());
    }

    @MainThread
    void handleStop(@NonNull Intent intent) {
        Logger.get().info(TAG, "Stopping foreground service");
        if (this.mCallback != null) {
            this.mCallback.stop();
        }
    }

    @MainThread
    private void handleCancelWork(@NonNull Intent intent) {
        Logger.get().info(TAG, "Stopping foreground work for " + intent);
        String workSpecId = intent.getStringExtra(KEY_WORKSPEC_ID);
        if (workSpecId != null && !TextUtils.isEmpty((CharSequence)workSpecId)) {
            this.mWorkManagerImpl.cancelWorkById(UUID.fromString(workSpecId));
        }
    }

    @Override
    public void onConstraintsStateChanged(@NonNull WorkSpec workSpec, @NonNull ConstraintsState state) {
        if (state instanceof ConstraintsState.ConstraintsNotMet) {
            String workSpecId = workSpec.id;
            Logger.get().debug(TAG, "Constraints unmet for WorkSpec " + workSpecId);
            this.mWorkManagerImpl.stopForegroundWork(WorkSpecKt.generationalId(workSpec), ((ConstraintsState.ConstraintsNotMet)state).getReason());
        }
    }

    @NonNull
    public static Intent createStartForegroundIntent(@NonNull Context context, @NonNull WorkGenerationalId id, @NonNull ForegroundInfo info) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_START_FOREGROUND);
        intent.putExtra(KEY_WORKSPEC_ID, id.getWorkSpecId());
        intent.putExtra(KEY_GENERATION, id.getGeneration());
        intent.putExtra(KEY_NOTIFICATION_ID, info.getNotificationId());
        intent.putExtra(KEY_FOREGROUND_SERVICE_TYPE, info.getForegroundServiceType());
        intent.putExtra(KEY_NOTIFICATION, (Parcelable)info.getNotification());
        return intent;
    }

    @NonNull
    public static Intent createCancelWorkIntent(@NonNull Context context, @NonNull String workSpecId) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_CANCEL_WORK);
        intent.setData(Uri.parse((String)("workspec://" + workSpecId)));
        intent.putExtra(KEY_WORKSPEC_ID, workSpecId);
        return intent;
    }

    @NonNull
    public static Intent createNotifyIntent(@NonNull Context context, @NonNull WorkGenerationalId id, @NonNull ForegroundInfo info) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_NOTIFY);
        intent.putExtra(KEY_NOTIFICATION_ID, info.getNotificationId());
        intent.putExtra(KEY_FOREGROUND_SERVICE_TYPE, info.getForegroundServiceType());
        intent.putExtra(KEY_NOTIFICATION, (Parcelable)info.getNotification());
        intent.putExtra(KEY_WORKSPEC_ID, id.getWorkSpecId());
        intent.putExtra(KEY_GENERATION, id.getGeneration());
        return intent;
    }

    @NonNull
    public static Intent createStopForegroundIntent(@NonNull Context context) {
        Intent intent = new Intent(context, SystemForegroundService.class);
        intent.setAction(ACTION_STOP_FOREGROUND);
        return intent;
    }

    static interface Callback {
        @MainThread
        public void startForeground(int var1, int var2, @NonNull Notification var3);

        @MainThread
        public void notify(int var1, @NonNull Notification var2);

        @MainThread
        public void cancelNotification(int var1);

        @MainThread
        public void stop();
    }
}

