/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.systemalarm;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.PowerManager;
import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.Processor;
import androidx.work.impl.StartStopTokens;
import androidx.work.impl.WorkLauncher;
import androidx.work.impl.WorkLauncherImpl;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.background.systemalarm.CommandHandler;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.WorkTimer;
import androidx.work.impl.utils.taskexecutor.SerialExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemAlarmDispatcher
implements ExecutionListener {
    static final String TAG = Logger.tagWithPrefix("SystemAlarmDispatcher");
    private static final String PROCESS_COMMAND_TAG = "ProcessCommand";
    private static final String KEY_START_ID = "KEY_START_ID";
    private static final int DEFAULT_START_ID = 0;
    final Context mContext;
    final TaskExecutor mTaskExecutor;
    private final WorkTimer mWorkTimer;
    private final Processor mProcessor;
    private final WorkManagerImpl mWorkManager;
    final CommandHandler mCommandHandler;
    final List<Intent> mIntents;
    Intent mCurrentIntent;
    @Nullable
    private CommandsCompletedListener mCompletedListener;
    private StartStopTokens mStartStopTokens;
    private final WorkLauncher mWorkLauncher;

    SystemAlarmDispatcher(@NonNull Context context) {
        this(context, null, null, null);
    }

    @VisibleForTesting
    SystemAlarmDispatcher(@NonNull Context context, @Nullable Processor processor, @Nullable WorkManagerImpl workManager, @Nullable WorkLauncher launcher) {
        this.mContext = context.getApplicationContext();
        this.mStartStopTokens = new StartStopTokens();
        this.mWorkManager = workManager != null ? workManager : WorkManagerImpl.getInstance(context);
        this.mCommandHandler = new CommandHandler(this.mContext, this.mWorkManager.getConfiguration().getClock(), this.mStartStopTokens);
        this.mWorkTimer = new WorkTimer(this.mWorkManager.getConfiguration().getRunnableScheduler());
        this.mProcessor = processor != null ? processor : this.mWorkManager.getProcessor();
        this.mTaskExecutor = this.mWorkManager.getWorkTaskExecutor();
        this.mWorkLauncher = launcher != null ? launcher : new WorkLauncherImpl(this.mProcessor, this.mTaskExecutor);
        this.mProcessor.addExecutionListener(this);
        this.mIntents = new ArrayList<Intent>();
        this.mCurrentIntent = null;
    }

    void onDestroy() {
        Logger.get().debug(TAG, "Destroying SystemAlarmDispatcher");
        this.mProcessor.removeExecutionListener(this);
        this.mCompletedListener = null;
    }

    @Override
    public void onExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        this.mTaskExecutor.getMainThreadExecutor().execute(new AddRunnable(this, CommandHandler.createExecutionCompletedIntent(this.mContext, id, needsReschedule), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public boolean add(@NonNull Intent intent, int startId) {
        Logger.get().debug(TAG, "Adding command " + intent + " (" + startId + ")");
        this.assertMainThread();
        String action = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)action)) {
            Logger.get().warning(TAG, "Unknown command. Ignoring");
            return false;
        }
        if ("ACTION_CONSTRAINTS_CHANGED".equals(action) && this.hasIntentWithAction("ACTION_CONSTRAINTS_CHANGED")) {
            return false;
        }
        intent.putExtra(KEY_START_ID, startId);
        List<Intent> list = this.mIntents;
        synchronized (list) {
            boolean hasCommands = !this.mIntents.isEmpty();
            this.mIntents.add(intent);
            if (!hasCommands) {
                this.processCommand();
            }
        }
        return true;
    }

    void setCompletedListener(@NonNull CommandsCompletedListener listener2) {
        if (this.mCompletedListener != null) {
            Logger.get().error(TAG, "A completion listener for SystemAlarmDispatcher already exists.");
            return;
        }
        this.mCompletedListener = listener2;
    }

    Processor getProcessor() {
        return this.mProcessor;
    }

    WorkTimer getWorkTimer() {
        return this.mWorkTimer;
    }

    WorkManagerImpl getWorkManager() {
        return this.mWorkManager;
    }

    TaskExecutor getTaskExecutor() {
        return this.mTaskExecutor;
    }

    WorkLauncher getWorkerLauncher() {
        return this.mWorkLauncher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    void dequeueAndCheckForCompletion() {
        Logger.get().debug(TAG, "Checking if commands are complete.");
        this.assertMainThread();
        List<Intent> list = this.mIntents;
        synchronized (list) {
            if (this.mCurrentIntent != null) {
                Logger.get().debug(TAG, "Removing command " + this.mCurrentIntent);
                if (!this.mIntents.remove(0).equals(this.mCurrentIntent)) {
                    throw new IllegalStateException("Dequeue-d command is not the first.");
                }
                this.mCurrentIntent = null;
            }
            SerialExecutor serialExecutor = this.mTaskExecutor.getSerialTaskExecutor();
            if (!this.mCommandHandler.hasPendingCommands() && this.mIntents.isEmpty() && !serialExecutor.hasPendingTasks()) {
                Logger.get().debug(TAG, "No more commands & intents.");
                if (this.mCompletedListener != null) {
                    this.mCompletedListener.onAllCommandsCompleted();
                }
            } else if (!this.mIntents.isEmpty()) {
                this.processCommand();
            }
        }
    }

    @MainThread
    private void processCommand() {
        this.assertMainThread();
        PowerManager.WakeLock processCommandLock = WakeLocks.newWakeLock(this.mContext, PROCESS_COMMAND_TAG);
        try {
            processCommandLock.acquire();
            this.mWorkManager.getWorkTaskExecutor().executeOnTaskThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<Intent> list = SystemAlarmDispatcher.this.mIntents;
                    synchronized (list) {
                        SystemAlarmDispatcher.this.mCurrentIntent = SystemAlarmDispatcher.this.mIntents.get(0);
                    }
                    if (SystemAlarmDispatcher.this.mCurrentIntent != null) {
                        String action = SystemAlarmDispatcher.this.mCurrentIntent.getAction();
                        int startId = SystemAlarmDispatcher.this.mCurrentIntent.getIntExtra(SystemAlarmDispatcher.KEY_START_ID, 0);
                        Logger.get().debug(TAG, "Processing command " + SystemAlarmDispatcher.this.mCurrentIntent + ", " + startId);
                        PowerManager.WakeLock wakeLock = WakeLocks.newWakeLock(SystemAlarmDispatcher.this.mContext, action + " (" + startId + ")");
                        try {
                            Logger.get().debug(TAG, "Acquiring operation wake lock (" + action + ") " + wakeLock);
                            wakeLock.acquire();
                            SystemAlarmDispatcher.this.mCommandHandler.onHandleIntent(SystemAlarmDispatcher.this.mCurrentIntent, startId, SystemAlarmDispatcher.this);
                        }
                        catch (Throwable throwable) {
                            Logger.get().error(TAG, "Unexpected error in onHandleIntent", throwable);
                        }
                        finally {
                            Logger.get().debug(TAG, "Releasing operation wake lock (" + action + ") " + wakeLock);
                            wakeLock.release();
                            SystemAlarmDispatcher.this.mTaskExecutor.getMainThreadExecutor().execute(new DequeueAndCheckForCompletion(SystemAlarmDispatcher.this));
                        }
                    }
                }
            });
        }
        finally {
            processCommandLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private boolean hasIntentWithAction(@NonNull String action) {
        this.assertMainThread();
        List<Intent> list = this.mIntents;
        synchronized (list) {
            for (Intent intent : this.mIntents) {
                if (!action.equals(intent.getAction())) continue;
                return true;
            }
            return false;
        }
    }

    private void assertMainThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Needs to be invoked on the main thread.");
        }
    }

    static interface CommandsCompletedListener {
        public void onAllCommandsCompleted();
    }

    static class AddRunnable
    implements Runnable {
        private final SystemAlarmDispatcher mDispatcher;
        private final Intent mIntent;
        private final int mStartId;

        AddRunnable(@NonNull SystemAlarmDispatcher dispatcher, @NonNull Intent intent, int startId) {
            this.mDispatcher = dispatcher;
            this.mIntent = intent;
            this.mStartId = startId;
        }

        @Override
        public void run() {
            this.mDispatcher.add(this.mIntent, this.mStartId);
        }
    }

    static class DequeueAndCheckForCompletion
    implements Runnable {
        private final SystemAlarmDispatcher mDispatcher;

        DequeueAndCheckForCompletion(@NonNull SystemAlarmDispatcher dispatcher) {
            this.mDispatcher = dispatcher;
        }

        @Override
        public void run() {
            this.mDispatcher.dequeueAndCheckForCompletion();
        }
    }
}

