/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.work.Configuration;
import androidx.work.ForegroundInfo;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import androidx.work.impl.ExecutionListener;
import androidx.work.impl.StartStopToken;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkerWrapper;
import androidx.work.impl.foreground.ForegroundProcessor;
import androidx.work.impl.foreground.SystemForegroundDispatcher;
import androidx.work.impl.model.WorkGenerationalId;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.utils.WakeLocks;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Processor
implements ForegroundProcessor {
    private static final String TAG = Logger.tagWithPrefix("Processor");
    private static final String FOREGROUND_WAKELOCK_TAG = "ProcessorForegroundLck";
    @Nullable
    private PowerManager.WakeLock mForegroundLock;
    private Context mAppContext;
    private Configuration mConfiguration;
    private TaskExecutor mWorkTaskExecutor;
    private WorkDatabase mWorkDatabase;
    private Map<String, WorkerWrapper> mForegroundWorkMap;
    private Map<String, WorkerWrapper> mEnqueuedWorkMap;
    private Map<String, Set<StartStopToken>> mWorkRuns;
    private Set<String> mCancelledIds;
    private final List<ExecutionListener> mOuterListeners;
    private final Object mLock;

    public Processor(@NonNull Context appContext, @NonNull Configuration configuration, @NonNull TaskExecutor workTaskExecutor, @NonNull WorkDatabase workDatabase) {
        this.mAppContext = appContext;
        this.mConfiguration = configuration;
        this.mWorkTaskExecutor = workTaskExecutor;
        this.mWorkDatabase = workDatabase;
        this.mEnqueuedWorkMap = new HashMap<String, WorkerWrapper>();
        this.mForegroundWorkMap = new HashMap<String, WorkerWrapper>();
        this.mCancelledIds = new HashSet<String>();
        this.mOuterListeners = new ArrayList<ExecutionListener>();
        this.mForegroundLock = null;
        this.mLock = new Object();
        this.mWorkRuns = new HashMap<String, Set<StartStopToken>>();
    }

    public boolean startWork(@NonNull StartStopToken id) {
        return this.startWork(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWork(@NonNull StartStopToken startStopToken, @Nullable WorkerParameters.RuntimeExtras runtimeExtras) {
        ArrayList<String> tags = new ArrayList<String>();
        WorkGenerationalId id = startStopToken.getId();
        String workSpecId = id.getWorkSpecId();
        WorkSpec workSpec = (WorkSpec)this.mWorkDatabase.runInTransaction(() -> {
            tags.addAll(this.mWorkDatabase.workTagDao().getTagsForWorkSpecId(workSpecId));
            return this.mWorkDatabase.workSpecDao().getWorkSpec(workSpecId);
        });
        if (workSpec == null) {
            Logger.get().warning(TAG, "Didn't find WorkSpec for id " + id);
            this.runOnExecuted(id, false);
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.isEnqueued(workSpecId)) {
                Set<StartStopToken> tokens = this.mWorkRuns.get(workSpecId);
                StartStopToken previousRun = tokens.iterator().next();
                int previousRunGeneration = previousRun.getId().getGeneration();
                if (previousRunGeneration == id.getGeneration()) {
                    tokens.add(startStopToken);
                    Logger.get().debug(TAG, "Work " + id + " is already enqueued for processing");
                } else {
                    this.runOnExecuted(id, false);
                }
                return false;
            }
            if (workSpec.getGeneration() != id.getGeneration()) {
                this.runOnExecuted(id, false);
                return false;
            }
            WorkerWrapper workWrapper = new WorkerWrapper.Builder(this.mAppContext, this.mConfiguration, this.mWorkTaskExecutor, this, this.mWorkDatabase, workSpec, tags).withRuntimeExtras(runtimeExtras).build();
            ListenableFuture<Boolean> future = workWrapper.launch();
            future.addListener(() -> {
                boolean needsReschedule;
                try {
                    needsReschedule = (Boolean)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    needsReschedule = true;
                }
                this.onExecuted(workWrapper, needsReschedule);
            }, this.mWorkTaskExecutor.getMainThreadExecutor());
            this.mEnqueuedWorkMap.put(workSpecId, workWrapper);
            HashSet<StartStopToken> set = new HashSet<StartStopToken>();
            set.add(startStopToken);
            this.mWorkRuns.put(workSpecId, set);
        }
        Logger.get().debug(TAG, this.getClass().getSimpleName() + ": processing " + id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startForeground(@NonNull String workSpecId, @NonNull ForegroundInfo foregroundInfo) {
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().info(TAG, "Moving WorkSpec (" + workSpecId + ") to the foreground");
            WorkerWrapper wrapper = this.mEnqueuedWorkMap.remove(workSpecId);
            if (wrapper != null) {
                if (this.mForegroundLock == null) {
                    this.mForegroundLock = WakeLocks.newWakeLock(this.mAppContext, FOREGROUND_WAKELOCK_TAG);
                    this.mForegroundLock.acquire();
                }
                this.mForegroundWorkMap.put(workSpecId, wrapper);
                Intent intent = SystemForegroundDispatcher.createStartForegroundIntent(this.mAppContext, wrapper.getWorkGenerationalId(), foregroundInfo);
                ContextCompat.startForegroundService((Context)this.mAppContext, (Intent)intent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopForegroundWork(@NonNull StartStopToken token, int reason) {
        WorkerWrapper wrapper;
        String id = token.getId().getWorkSpecId();
        Object object = this.mLock;
        synchronized (object) {
            wrapper = this.cleanUpWorkerUnsafe(id);
        }
        return Processor.interrupt(id, wrapper, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopWork(@NonNull StartStopToken runId, int reason) {
        WorkerWrapper wrapper;
        String id = runId.getId().getWorkSpecId();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mForegroundWorkMap.get(id) != null) {
                Logger.get().debug(TAG, "Ignored stopWork. WorkerWrapper " + id + " is in foreground");
                return false;
            }
            Set<StartStopToken> runs = this.mWorkRuns.get(id);
            if (runs == null || !runs.contains(runId)) {
                return false;
            }
            wrapper = this.cleanUpWorkerUnsafe(id);
        }
        return Processor.interrupt(id, wrapper, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAndCancelWork(@NonNull String id, int reason) {
        WorkerWrapper wrapper;
        Object object = this.mLock;
        synchronized (object) {
            Logger.get().debug(TAG, "Processor cancelling " + id);
            this.mCancelledIds.add(id);
            wrapper = this.cleanUpWorkerUnsafe(id);
        }
        return Processor.interrupt(id, wrapper, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled(@NonNull String id) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCancelledIds.contains(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWork() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mEnqueuedWorkMap.isEmpty() || !this.mForegroundWorkMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.getWorkerWrapperUnsafe(workSpecId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.add(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionListener(@NonNull ExecutionListener executionListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOuterListeners.remove(executionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExecuted(@NonNull WorkerWrapper wrapper, boolean needsReschedule) {
        Object object = this.mLock;
        synchronized (object) {
            WorkGenerationalId id = wrapper.getWorkGenerationalId();
            String workSpecId = id.getWorkSpecId();
            WorkerWrapper workerWrapper = this.getWorkerWrapperUnsafe(workSpecId);
            if (workerWrapper == wrapper) {
                this.cleanUpWorkerUnsafe(workSpecId);
            }
            Logger.get().debug(TAG, this.getClass().getSimpleName() + " " + workSpecId + " executed; reschedule = " + needsReschedule);
            for (ExecutionListener executionListener : this.mOuterListeners) {
                executionListener.onExecuted(id, needsReschedule);
            }
        }
    }

    @Nullable
    private WorkerWrapper getWorkerWrapperUnsafe(@NonNull String workSpecId) {
        WorkerWrapper workerWrapper = this.mForegroundWorkMap.get(workSpecId);
        if (workerWrapper == null) {
            workerWrapper = this.mEnqueuedWorkMap.get(workSpecId);
        }
        return workerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public WorkSpec getRunningWorkSpec(@NonNull String workSpecId) {
        Object object = this.mLock;
        synchronized (object) {
            WorkerWrapper workerWrapper = this.getWorkerWrapperUnsafe(workSpecId);
            if (workerWrapper != null) {
                return workerWrapper.getWorkSpec();
            }
            return null;
        }
    }

    private void runOnExecuted(@NonNull WorkGenerationalId id, boolean needsReschedule) {
        this.mWorkTaskExecutor.getMainThreadExecutor().execute(() -> {
            Object object = this.mLock;
            synchronized (object) {
                for (ExecutionListener executionListener : this.mOuterListeners) {
                    executionListener.onExecuted(id, needsReschedule);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopForegroundService() {
        Object object = this.mLock;
        synchronized (object) {
            boolean hasForegroundWork;
            boolean bl = hasForegroundWork = !this.mForegroundWorkMap.isEmpty();
            if (!hasForegroundWork) {
                Intent intent = SystemForegroundDispatcher.createStopForegroundIntent(this.mAppContext);
                try {
                    this.mAppContext.startService(intent);
                }
                catch (Throwable throwable) {
                    Logger.get().error(TAG, "Unable to stop foreground service", throwable);
                }
                if (this.mForegroundLock != null) {
                    this.mForegroundLock.release();
                    this.mForegroundLock = null;
                }
            }
        }
    }

    @Nullable
    private WorkerWrapper cleanUpWorkerUnsafe(@NonNull String id) {
        boolean wasForeground;
        WorkerWrapper wrapper = this.mForegroundWorkMap.remove(id);
        boolean bl = wasForeground = wrapper != null;
        if (!wasForeground) {
            wrapper = this.mEnqueuedWorkMap.remove(id);
        }
        this.mWorkRuns.remove(id);
        if (wasForeground) {
            this.stopForegroundService();
        }
        return wrapper;
    }

    private static boolean interrupt(@NonNull String id, @Nullable WorkerWrapper wrapper, int stopReason) {
        if (wrapper != null) {
            wrapper.interrupt(stopReason);
            Logger.get().debug(TAG, "WorkerWrapper interrupted for " + id);
            return true;
        }
        Logger.get().debug(TAG, "WorkerWrapper could not be found for " + id);
        return false;
    }
}

