/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.lint;

import androidx.work.lint.RemoveWorkManagerInitializerDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/work/lint/RemoveWorkManagerInitializerDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "applicationImplementsConfigurationProvider", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "removedDefaultInitializer", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "applicableSuperClasses", "", "", "getApplicableElements", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "work-runtime-lint"})
public final class RemoveWorkManagerInitializerDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean removedDefaultInitializer;
    @Nullable
    private Location location;
    private boolean applicationImplementsConfigurationProvider;
    @NotNull
    private static final String DESCRIPTION = "Remove androidx.work.WorkManagerInitializer from your AndroidManifest.xml when using on-demand initialization.";
    @NotNull
    private static final Issue ISSUE;
    @NotNull
    private static final String ATTR_NODE = "node";

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"application");
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.app.Application");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        NodeList metadataElements;
        Node metadata2;
        NodeList providers;
        Node provider2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.location == null) {
            this.location = context.getLocation((Node)element);
        }
        if ((provider2 = Companion.find(providers = element.getElementsByTagName("provider"), (Function1<? super Node, Boolean>)((Function1)visitElement.provider.1.INSTANCE))) != null) {
            Node remove;
            this.location = context.getLocation(provider2);
            Node node = remove = provider2.getAttributes().getNamedItemNS("http://schemas.android.com/tools", ATTR_NODE);
            if (Intrinsics.areEqual((Object)(node != null ? node.getTextContent() : null), (Object)"remove")) {
                this.removedDefaultInitializer = true;
            }
        }
        if ((metadata2 = Companion.find(metadataElements = element.getElementsByTagName("meta-data"), (Function1<? super Node, Boolean>)((Function1)visitElement.metadata.1.INSTANCE))) != null && !this.removedDefaultInitializer) {
            Node remove;
            this.location = context.getLocation(metadata2);
            Node node = remove = metadata2.getAttributes().getNamedItemNS("http://schemas.android.com/tools", ATTR_NODE);
            if (Intrinsics.areEqual((Object)(node != null ? node.getTextContent() : null), (Object)"remove")) {
                this.removedDefaultInitializer = true;
            }
        }
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!context.getEvaluator().inheritsFrom(declaration.getJavaPsi(), "android.app.Application", false)) {
            return;
        }
        if (context.getEvaluator().isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        if (context.getDriver().isSuppressed(context, ISSUE, (PsiElement)declaration.getJavaPsi())) {
            return;
        }
        if (context.getEvaluator().implementsInterface(declaration.getJavaPsi(), "androidx.work.Configuration.Provider", false)) {
            this.applicationImplementsConfigurationProvider = true;
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Location location = this.location;
        if (location == null) {
            return;
        }
        Location location2 = location;
        if (this.applicationImplementsConfigurationProvider && !this.removedDefaultInitializer) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location2, (String)DESCRIPTION, null, (int)8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(RemoveWorkManagerInitializerDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"RemoveWorkManagerInitializer", (String)DESCRIPTION, (String)"\n                If an `android.app.Application` implements `androidx.work.Configuration.Provider`,\n                the default `androidx.startup.InitializationProvider` needs to be removed from the\n                AndroidManifest.xml file.\n            ", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\n\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Landroidx/work/lint/RemoveWorkManagerInitializerDetector$Companion;", "", "()V", "ATTR_NODE", "", "DESCRIPTION", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "find", "Lorg/w3c/dom/Node;", "Lorg/w3c/dom/NodeList;", "fn", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "node", "", "work-runtime-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        @Nullable
        public final Node find(@Nullable NodeList $this$find, @NotNull Function1<? super Node, Boolean> fn) {
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            if ($this$find == null) {
                return null;
            }
            int n = $this$find.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = $this$find.item(i);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)RemoveWorkManagerInitializerDetector.ATTR_NODE);
                if (!((Boolean)fn.invoke((Object)node)).booleanValue()) continue;
                return node;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

