/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.content.Context;
import android.os.PowerManager;
import androidx.work.Logger;
import androidx.work.impl.utils.WakeLocksHolder;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"TAG", "", "checkWakeLocks", "", "newWakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "context", "Landroid/content/Context;", "tag", "work-runtime_release"})
@JvmName(name="WakeLocks")
@SourceDebugExtension(value={"SMAP\nWakeLocks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WakeLocks.kt\nandroidx/work/impl/utils/WakeLocks\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n215#2,2:74\n*S KotlinDebug\n*F\n+ 1 WakeLocks.kt\nandroidx/work/impl/utils/WakeLocks\n*L\n65#1:74,2\n*E\n"})
public final class WakeLocks {
    @NotNull
    private static final String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final PowerManager.WakeLock newWakeLock(@NotNull Context context, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = context.getApplicationContext().getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager powerManager = (PowerManager)object;
        String tagWithPrefix = "WorkManager: " + tag;
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, tagWithPrefix);
        WakeLocksHolder wakeLocksHolder = WakeLocksHolder.INSTANCE;
        synchronized (wakeLocksHolder) {
            boolean bl = false;
            String string = WakeLocksHolder.INSTANCE.getWakeLocks().put(wakeLock, tagWithPrefix);
        }
        Intrinsics.checkNotNullExpressionValue((Object)wakeLock, (String)"wakeLock");
        return wakeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkWakeLocks() {
        Object object;
        Map wakeLocksCopy = new LinkedHashMap();
        WakeLocksHolder wakeLocksHolder = WakeLocksHolder.INSTANCE;
        synchronized (wakeLocksHolder) {
            boolean bl = false;
            wakeLocksCopy.putAll((Map)WakeLocksHolder.INSTANCE.getWakeLocks());
            object = Unit.INSTANCE;
        }
        Map $this$forEach$iv = wakeLocksCopy;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            PowerManager.WakeLock wakeLock = (PowerManager.WakeLock)entry.getKey();
            String tag = (String)entry.getValue();
            PowerManager.WakeLock wakeLock2 = wakeLock;
            boolean bl2 = wakeLock2 != null ? wakeLock2.isHeld() : false;
            if (!bl2) continue;
            Logger.get().warning(TAG, "WakeLock held for " + tag);
        }
    }

    static {
        String string = Logger.tagWithPrefix("WakeLocks");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"WakeLocks\")");
        TAG = string;
    }
}

