/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.WorkRequest;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.workers.ConstraintTrackingWorker;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u001a\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME", "", "ARGUMENT_SERVICE_CLASS_NAME", "ARGUMENT_SERVICE_PACKAGE_NAME", "REMOTE_DELEGATING_LISTENABLE_WORKER_CLASS_NAME", "checkContentUriTriggerWorkerLimits", "", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "configuration", "Landroidx/work/Configuration;", "continuation", "Landroidx/work/impl/WorkContinuationImpl;", "tryDelegateConstrainedWorkSpec", "Landroidx/work/impl/model/WorkSpec;", "workSpec", "tryDelegateRemoteListenableWorker", "usesScheduler", "", "schedulers", "", "Landroidx/work/impl/Scheduler;", "className", "wrapWorkSpecIfNeeded", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nEnqueueUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnqueueUtils.kt\nandroidx/work/impl/utils/EnqueueUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Data_.kt\nandroidx/work/Data\n*L\n1#1,163:1\n1774#2,4:164\n1747#2,3:172\n1#3:168\n233#4:169\n233#4:170\n233#4:171\n*S KotlinDebug\n*F\n+ 1 EnqueueUtils.kt\nandroidx/work/impl/utils/EnqueueUtilsKt\n*L\n44#1:164,4\n139#1:172,3\n70#1:169\n71#1:170\n72#1:171\n*E\n"})
public final class EnqueueUtilsKt {
    @NotNull
    public static final String REMOTE_DELEGATING_LISTENABLE_WORKER_CLASS_NAME = "androidx.work.multiprocess.RemoteListenableDelegatingWorker";
    @NotNull
    public static final String ARGUMENT_SERVICE_PACKAGE_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_PACKAGE_NAME";
    @NotNull
    public static final String ARGUMENT_SERVICE_CLASS_NAME = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_CLASS_NAME";
    @NotNull
    public static final String ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME = "androidx.work.multiprocess.RemoteListenableDelegatingWorker.ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME";

    /*
     * WARNING - void declaration
     */
    public static final void checkContentUriTriggerWorkerLimits(@NotNull WorkDatabase workDatabase, @NotNull Configuration configuration, @NotNull WorkContinuationImpl continuation) {
        int limit;
        Intrinsics.checkNotNullParameter((Object)((Object)workDatabase), (String)"workDatabase");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        Object[] objectArray = new WorkContinuationImpl[]{continuation};
        List continuations = CollectionsKt.mutableListOf((Object[])objectArray);
        int newCount = 0;
        while (!((Collection)continuations).isEmpty()) {
            List<WorkContinuationImpl> it;
            int n;
            void $this$count$iv;
            WorkContinuationImpl current = (WorkContinuationImpl)CollectionsKt.removeLast((List)continuations);
            List<? extends WorkRequest> list = current.getWork();
            Intrinsics.checkNotNullExpressionValue(list, (String)"current.work");
            Iterable iterable = list;
            int n2 = newCount;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    WorkRequest it2 = (WorkRequest)element$iv;
                    boolean bl = false;
                    if (!it2.getWorkSpec().constraints.hasContentUriTriggers() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            newCount = n2 + n3;
            if (current.getParents() == null) continue;
            boolean bl = false;
            continuations.addAll((Collection)it);
        }
        if (newCount == 0) {
            return;
        }
        int alreadyEnqueuedCount = workDatabase.workSpecDao().countNonFinishedContentUriTriggerWorkers();
        if (alreadyEnqueuedCount + newCount > (limit = configuration.getContentUriTriggerWorkersLimit())) {
            throw new IllegalArgumentException("Too many workers with contentUriTriggers are enqueued:\ncontentUriTrigger workers limit: " + limit + ";\nalready enqueued count: " + alreadyEnqueuedCount + ";\ncurrent enqueue operation count: " + newCount + ".\nTo address this issue you can: \n1. enqueue less workers or batch some of workers with content uri triggers together;\n2. increase limit via Configuration.Builder.setContentUriTriggerWorkersLimit;\nPlease beware that workers with content uri triggers immediately occupy slots in JobScheduler so no updates to content uris are missed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final WorkSpec tryDelegateRemoteListenableWorker(@NotNull WorkSpec workSpec) {
        void this_$iv;
        void this_$iv2;
        void this_$iv3;
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Data data = workSpec.input;
        Object key$iv = ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME;
        boolean $i$f$hasKey$work_runtime_release = false;
        boolean hasDelegateWorker = this_$iv3.hasKeyWithValueOfType((String)key$iv, String.class);
        key$iv = workSpec.input;
        Object key$iv2 = ARGUMENT_SERVICE_PACKAGE_NAME;
        boolean $i$f$hasKey$work_runtime_release2 = false;
        boolean hasPackageName = this_$iv2.hasKeyWithValueOfType((String)key$iv2, String.class);
        key$iv2 = workSpec.input;
        String key$iv3 = ARGUMENT_SERVICE_CLASS_NAME;
        boolean $i$f$hasKey$work_runtime_release3 = false;
        boolean hasClassName = this_$iv.hasKeyWithValueOfType(key$iv3, String.class);
        if (!hasDelegateWorker && hasPackageName && hasClassName) {
            String workerClassName = workSpec.workerClassName;
            Data newInputData = new Data.Builder().putAll(workSpec.input).putString(ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME, workerClassName).build();
            return WorkSpec.copy$default(workSpec, null, null, REMOTE_DELEGATING_LISTENABLE_WORKER_CLASS_NAME, null, newInputData, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 0L, 0, 0, null, 0xFFFFEB, null);
        }
        return workSpec;
    }

    @NotNull
    public static final WorkSpec tryDelegateConstrainedWorkSpec(@NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Constraints constraints = workSpec.constraints;
        String workerClassName = workSpec.workerClassName;
        boolean isConstraintTrackingWorker = Intrinsics.areEqual((Object)workerClassName, (Object)ConstraintTrackingWorker.class.getName());
        if (!isConstraintTrackingWorker && (constraints.requiresBatteryNotLow() || constraints.requiresStorageNotLow())) {
            Data newInputData = new Data.Builder().putAll(workSpec.input).putString("androidx.work.impl.workers.ConstraintTrackingWorker.ARGUMENT_CLASS_NAME", workerClassName).build();
            String string = ConstraintTrackingWorker.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            return WorkSpec.copy$default(workSpec, null, null, string, null, newInputData, null, 0L, 0L, 0L, null, 0, null, 0L, 0L, 0L, 0L, false, null, 0, 0, 0L, 0, 0, null, 0xFFFFEB, null);
        }
        return workSpec;
    }

    @NotNull
    public static final WorkSpec wrapWorkSpecIfNeeded(@NotNull List<? extends Scheduler> schedulers2, @NotNull WorkSpec workSpec) {
        Intrinsics.checkNotNullParameter(schedulers2, (String)"schedulers");
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        WorkSpec delegated = EnqueueUtilsKt.tryDelegateRemoteListenableWorker(workSpec);
        int n = Build.VERSION.SDK_INT;
        return (23 <= n ? n < 26 : false) ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(delegated) : (Build.VERSION.SDK_INT <= 22 && EnqueueUtilsKt.usesScheduler(schedulers2, "androidx.work.impl.background.gcm.GcmScheduler") ? EnqueueUtilsKt.tryDelegateConstrainedWorkSpec(delegated) : delegated);
    }

    private static final boolean usesScheduler(List<? extends Scheduler> schedulers2, String className) {
        try {
            boolean bl;
            block5: {
                Class<?> klass = Class.forName(className);
                Iterable $this$any$iv = schedulers2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Scheduler scheduler = (Scheduler)element$iv;
                        boolean bl2 = false;
                        if (!klass.isAssignableFrom(scheduler.getClass())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        catch (ClassNotFoundException ignore) {
            return false;
        }
    }
}

