/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.constraints;

import android.os.Build;
import androidx.work.Logger;
import androidx.work.impl.constraints.ConstraintsState;
import androidx.work.impl.constraints.WorkConstraintsTracker;
import androidx.work.impl.constraints.WorkConstraintsTrackerKt;
import androidx.work.impl.constraints.controllers.BatteryChargingController;
import androidx.work.impl.constraints.controllers.BatteryNotLowController;
import androidx.work.impl.constraints.controllers.ConstraintController;
import androidx.work.impl.constraints.controllers.NetworkConnectedController;
import androidx.work.impl.constraints.controllers.NetworkMeteredController;
import androidx.work.impl.constraints.controllers.NetworkNotRoamingController;
import androidx.work.impl.constraints.controllers.NetworkUnmeteredController;
import androidx.work.impl.constraints.controllers.StorageNotLowController;
import androidx.work.impl.constraints.trackers.Trackers;
import androidx.work.impl.model.WorkSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.internal.CombineKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/work/impl/constraints/WorkConstraintsTracker;", "", "trackers", "Landroidx/work/impl/constraints/trackers/Trackers;", "(Landroidx/work/impl/constraints/trackers/Trackers;)V", "controllers", "", "Landroidx/work/impl/constraints/controllers/ConstraintController;", "(Ljava/util/List;)V", "areAllConstraintsMet", "", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "track", "Lkotlinx/coroutines/flow/Flow;", "Landroidx/work/impl/constraints/ConstraintsState;", "spec", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nWorkConstraintsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkConstraintsTracker.kt\nandroidx/work/impl/constraints/WorkConstraintsTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Zip.kt\nkotlinx/coroutines/flow/FlowKt__ZipKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n1549#2:215\n1620#2,3:216\n766#2:224\n857#2,2:225\n287#3:219\n288#3:222\n37#4,2:220\n107#5:223\n*S KotlinDebug\n*F\n+ 1 WorkConstraintsTracker.kt\nandroidx/work/impl/constraints/WorkConstraintsTracker\n*L\n98#1:212\n98#1:213,2\n98#1:215\n98#1:216,3\n105#1:224\n105#1:225,2\n99#1:219\n99#1:222\n99#1:220,2\n99#1:223\n*E\n"})
public final class WorkConstraintsTracker {
    @NotNull
    private final List<ConstraintController> controllers;

    public WorkConstraintsTracker(@NotNull List<? extends ConstraintController> controllers) {
        Intrinsics.checkNotNullParameter(controllers, (String)"controllers");
        this.controllers = controllers;
    }

    public WorkConstraintsTracker(@NotNull Trackers trackers) {
        Intrinsics.checkNotNullParameter((Object)trackers, (String)"trackers");
        Object[] objectArray = new ConstraintController[]{new BatteryChargingController(trackers.getBatteryChargingTracker()), new BatteryNotLowController(trackers.getBatteryNotLowTracker()), new StorageNotLowController(trackers.getStorageNotLowTracker()), new NetworkConnectedController(trackers.getNetworkStateTracker()), new NetworkUnmeteredController(trackers.getNetworkStateTracker()), new NetworkNotRoamingController(trackers.getNetworkStateTracker()), new NetworkMeteredController(trackers.getNetworkStateTracker()), Build.VERSION.SDK_INT >= 28 ? WorkConstraintsTrackerKt.NetworkRequestConstraintController(trackers.getContext()) : null};
        this(CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flow<ConstraintsState> track(@NotNull WorkSpec spec) {
        void $this$mapTo$iv$iv;
        ConstraintController it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Iterable $this$filter$iv = this.controllers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintController)element$iv$iv;
            boolean bl = false;
            if (!it.hasConstraint(spec)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConstraintController)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.track(spec.constraints));
        }
        List flows = (List)destination$iv$iv;
        boolean $i$f$combine = false;
        Collection $this$toTypedArray$iv$iv = CollectionsKt.toList((Iterable)flows);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        Flow[] flowArray$iv = thisCollection$iv$iv.toArray(new Flow[0]);
        boolean $i$f$unsafeFlow = false;
        return FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<ConstraintsState>(flowArray$iv){
            final /* synthetic */ Flow[] $flowArray$inlined;
            {
                this.$flowArray$inlined = flowArray;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$combine_u24lambda_u2411 = collector;
                boolean bl = false;
                Object object = CombineKt.combineInternal((FlowCollector)$this$combine_u24lambda_u2411, (Flow[])this.$flowArray$inlined, (Function0)((Function0)new Function0<ConstraintsState[]>(this.$flowArray$inlined){
                    final /* synthetic */ Flow[] $flowArray;
                    {
                        this.$flowArray = $flowArray;
                        super(0);
                    }

                    @Nullable
                    public final ConstraintsState[] invoke() {
                        return new ConstraintsState[this.$flowArray.length];
                    }
                }), (Function3)((Function3)new Function3<FlowCollector<? super ConstraintsState>, ConstraintsState[], Continuation<? super Unit>, Object>(null){
                    int label;
                    private /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$combineInternal = (FlowCollector)this.L$0;
                                it = (Object[])this.L$1;
                                var5_5 = $this$combineInternal;
                                (Continuation)this;
                                states = (ConstraintsState[])it;
                                $i$a$-combine-WorkConstraintsTracker$track$1 = false;
                                $this$firstOrNull$iv = states;
                                $i$f$firstOrNull = false;
                                var11_11 = $this$firstOrNull$iv.length;
                                for (var10_10 = 0; var10_10 < var11_11; ++var10_10) {
                                    it = element$iv = $this$firstOrNull$iv[var10_10];
                                    $i$a$-firstOrNull-WorkConstraintsTracker$track$1$1 = false;
                                    if (!(Intrinsics.areEqual((Object)it, (Object)ConstraintsState.ConstraintsMet.INSTANCE) == false)) continue;
                                    v0 = element$iv;
                                    ** GOTO lbl22
                                }
                                v0 = v1 = null;
lbl22:
                                // 2 sources

                                if (v0 == null) {
                                    v1 = ConstraintsState.ConstraintsMet.INSTANCE;
                                }
                                this.label = 1;
                                v2 = var5_5.emit((Object)v1, (Continuation)this);
                                if (v2 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl32
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl32:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    @Nullable
                    public final Object invoke(@NotNull FlowCollector p1, @NotNull Object[] p2, @Nullable Continuation p3) {
                        Function3<FlowCollector<? super ConstraintsState>, ConstraintsState[], Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p1;
                        function3.L$1 = p2;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                }), (Continuation)$completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean areAllConstraintsMet(@NotNull WorkSpec workSpec) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)workSpec, (String)"workSpec");
        Iterable $this$filter$iv = this.controllers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConstraintController it = (ConstraintController)element$iv$iv;
            boolean bl = false;
            if (!it.isCurrentlyConstrained(workSpec)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List controllers = (List)destination$iv$iv;
        if (!((Collection)controllers).isEmpty()) {
            Logger.get().debug(WorkConstraintsTrackerKt.access$getTAG$p(), "Work " + workSpec.id + " constrained by " + CollectionsKt.joinToString$default((Iterable)controllers, null, null, null, (int)0, null, (Function1)areAllConstraintsMet.1.INSTANCE, (int)31, null));
        }
        return controllers.isEmpty();
    }
}

