/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.background.greedy;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.Clock;
import androidx.work.Logger;
import androidx.work.RunnableScheduler;
import androidx.work.impl.Scheduler;
import androidx.work.impl.model.WorkSpec;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DelayedWorkTracker {
    static final String TAG = Logger.tagWithPrefix("DelayedWorkTracker");
    final Scheduler mImmediateScheduler;
    private final RunnableScheduler mRunnableScheduler;
    private final Clock mClock;
    private final Map<String, Runnable> mRunnables;

    public DelayedWorkTracker(@NonNull Scheduler immediateScheduler, @NonNull RunnableScheduler runnableScheduler, @NonNull Clock clock) {
        this.mImmediateScheduler = immediateScheduler;
        this.mRunnableScheduler = runnableScheduler;
        this.mClock = clock;
        this.mRunnables = new HashMap<String, Runnable>();
    }

    public void schedule(final @NonNull WorkSpec workSpec, long nextRunTime) {
        Runnable existing = this.mRunnables.remove(workSpec.id);
        if (existing != null) {
            this.mRunnableScheduler.cancel(existing);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Logger.get().debug(TAG, "Scheduling work " + workSpec.id);
                DelayedWorkTracker.this.mImmediateScheduler.schedule(workSpec);
            }
        };
        this.mRunnables.put(workSpec.id, runnable);
        long now = this.mClock.currentTimeMillis();
        long delay = nextRunTime - now;
        this.mRunnableScheduler.scheduleWithDelay(delay, runnable);
    }

    public void unschedule(@NonNull String workSpecId) {
        Runnable runnable = this.mRunnables.remove(workSpecId);
        if (runnable != null) {
            this.mRunnableScheduler.cancel(runnable);
        }
    }
}

